/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseMod;
import java.util.EnumSet;

public class BaseModTicker
implements ITickHandler {
    private BaseMod mod;
    private EnumSet<TickType> ticks;

    BaseModTicker(BaseMod mod) {
        this.mod = mod;
        this.ticks = EnumSet.noneOf(TickType.class);
    }

    BaseModTicker(EnumSet<TickType> ticks) {
        this.ticks = ticks;
    }

    @Override
    public void tickStart(EnumSet<TickType> types, Object ... tickData) {
        this.tickBaseMod(types, false, tickData);
    }

    @Override
    public void tickEnd(EnumSet<TickType> types, Object ... tickData) {
        this.tickBaseMod(this.ticks, true, tickData);
    }

    private void tickBaseMod(EnumSet<TickType> types, boolean end, Object ... tickData) {
        for (TickType type : types) {
            boolean keepTicking;
            if (!this.ticks.contains((Object)type) || (keepTicking = this.mod.doTickInGame(type, end, FMLCommonHandler.instance().getMinecraftInstance(), tickData))) continue;
            this.ticks.remove((Object)type);
            this.ticks.removeAll(type.partnerTicks());
        }
    }

    @Override
    public EnumSet<TickType> ticks() {
        return this.ticks;
    }

    @Override
    public String getLabel() {
        return this.mod.getClass().getSimpleName();
    }

    public void setMod(BaseMod mod) {
        this.mod = mod;
    }
}

