/*
 * Decompiled with CFR 0.152.
 */
package forge;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class[][] ctrs = new Class[][]{{kt.class}, {dq.class, Integer.TYPE, int[].class, Integer.TYPE}, {kh.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {cc.class}, {mu.class, Class.class, Integer.TYPE, na.class, Boolean.TYPE}, {rv.class}, {rp.class}, {sw.class}, {kw.class}, {fe.class, Integer.TYPE}, {dv.class}, {ck.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE}};
    private static boolean[] decompiledFlags = new boolean[ctrs.length];

    public static kt addAction(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[0], kt.class, name, new Class[0], new Object[0]);
    }

    public static dq addArmorMaterial(String name, int durability, int[] reductionAmounts, int enchantability) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[1], dq.class, name, new Class[]{Integer.TYPE, int[].class, Integer.TYPE}, new Object[]{durability, reductionAmounts, enchantability});
    }

    public static kh addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[2], kh.class, name, new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{tile, sizeX, sizeY, offsetX, offsetY});
    }

    public static cc addCreatureAttribute(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[3], cc.class, name, new Class[0], new Object[0]);
    }

    public static mu addCreatureType(String name, Class typeClass, int maxNumber, na material, boolean peaceful) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[4], mu.class, name, new Class[]{Class.class, Integer.TYPE, na.class, Boolean.TYPE}, new Object[]{typeClass, maxNumber, material, peaceful});
    }

    public static rv addDoor(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[5], rv.class, name, new Class[0], new Object[0]);
    }

    public static rp addEnchantmentType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[6], rp.class, name, new Class[0], new Object[0]);
    }

    public static sw addMobType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[7], sw.class, name, new Class[0], new Object[0]);
    }

    public static kw addMovingObjectType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[8], kw.class, name, new Class[0], new Object[0]);
    }

    public static fe addSkyBlock(String name, int lightValue) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[9], fe.class, name, new Class[]{Integer.TYPE}, new Object[]{lightValue});
    }

    public static dv addStatus(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[10], dv.class, name, new Class[0], new Object[0]);
    }

    public static ck addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, int damage, int enchantability) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(decompiledFlags[11], ck.class, name, new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{harvestLevel, maxUses, Float.valueOf(efficiency), damage, enchantability});
    }

    private static void setup() {
        if (isSetup) {
            return;
        }
        for (int x2 = 0; x2 < ctrs.length; ++x2) {
            try {
                Class[] enumHeaders = new Class[ctrs[x2].length + 3];
                enumHeaders[0] = String.class;
                enumHeaders[1] = Integer.TYPE;
                enumHeaders[2] = String.class;
                enumHeaders[3] = Integer.TYPE;
                for (int y = 1; y < ctrs[x2].length; ++y) {
                    enumHeaders[3 + y] = ctrs[x2][y];
                }
                ctrs[x2][0].getDeclaredConstructor(enumHeaders);
                EnumHelper.decompiledFlags[x2] = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(boolean decompiled, Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = null;
        if (decompiled) {
            parameterTypes = new Class[additionalParameterTypes.length + 4];
            parameterTypes[0] = String.class;
            parameterTypes[1] = Integer.TYPE;
            parameterTypes[2] = String.class;
            parameterTypes[3] = Integer.TYPE;
            System.arraycopy(additionalParameterTypes, 0, parameterTypes, 4, additionalParameterTypes.length);
        } else {
            parameterTypes = new Class[additionalParameterTypes.length + 2];
            parameterTypes[0] = String.class;
            parameterTypes[1] = Integer.TYPE;
            System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        }
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(boolean decompiled, Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = null;
        if (decompiled) {
            parms = new Object[additionalValues.length + 4];
            parms[0] = value;
            parms[1] = ordinal;
            parms[2] = value;
            parms[3] = ordinal;
            System.arraycopy(additionalValues, 0, parms, 4, additionalValues.length);
        } else {
            parms = new Object[additionalValues.length + 2];
            parms[0] = value;
            parms[1] = ordinal;
            System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(decompiled, enumClass, additionalTypes), new Object[]{parms})));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, boolean decompiled) {
        return EnumHelper.addEnum(decompiled, enumType, enumName, new Class[0], new Object[0]);
    }

    public static <T extends Enum<?>> T addEnum(boolean decompiled, Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        Field[] fields = enumType.getDeclaredFields();
        int flags = 4122;
        String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
        for (Field field : fields) {
            if (decompiled) {
                if (!field.getName().contains("$VALUES")) continue;
                valuesField = field;
                break;
            }
            if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
            valuesField = field;
            break;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = EnumHelper.makeEnum(decompiled, enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

