/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.AchievementPage;
import forge.DungeonLoot;
import forge.EntityTrackerInfo;
import forge.ForgeHooks;
import forge.IArrowLooseHandler;
import forge.IArrowNockHandler;
import forge.IBonemealHandler;
import forge.IBucketHandler;
import forge.IChatHandler;
import forge.IChunkLoadHandler;
import forge.IConnectionHandler;
import forge.ICraftingHandler;
import forge.IDestroyToolHandler;
import forge.IEntityInteractHandler;
import forge.IEntityLivingHandler;
import forge.IFuelHandler;
import forge.IGuiHandler;
import forge.IHoeHandler;
import forge.IMinecartHandler;
import forge.IOreHandler;
import forge.IPickupHandler;
import forge.ISaveEventHandler;
import forge.ISleepHandler;
import forge.ISpecialMobSpawnHandler;
import forge.MinecartKey;
import forge.NetworkMod;
import forge.ObjectPair;
import forge.oredict.OreDictionary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class MinecraftForge {
    private static LinkedList<IBucketHandler> bucketHandlers = new LinkedList();
    private static int dungeonLootAttempts = 8;
    private static ArrayList<ObjectPair<Float, String>> dungeonMobs = new ArrayList();
    private static ArrayList<ObjectPair<Float, DungeonLoot>> dungeonLoot = new ArrayList();
    private static LinkedList<AchievementPage> achievementPages = new LinkedList();
    private static Map<MinecartKey, kp> itemForMinecart = new HashMap<MinecartKey, kp>();
    private static Map<kp, MinecartKey> minecartForItem = new HashMap<kp, MinecartKey>();
    private static int isClient = -1;

    public static void registerCustomBucketHandler(IBucketHandler handler) {
        bucketHandlers.add(handler);
    }

    public static void registerSleepHandler(ISleepHandler handler) {
        ForgeHooks.sleepHandlers.add(handler);
    }

    public static void registerBonemealHandler(IBonemealHandler handler) {
        ForgeHooks.bonemealHandlers.add(handler);
    }

    public static void registerHoeHandler(IHoeHandler handler) {
        ForgeHooks.hoeHandlers.add(handler);
    }

    public static void registerDestroyToolHandler(IDestroyToolHandler handler) {
        ForgeHooks.destroyToolHandlers.add(handler);
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        ForgeHooks.craftingHandlers.add(handler);
    }

    public static void registerMinecartHandler(IMinecartHandler handler) {
        ForgeHooks.minecartHandlers.add(handler);
    }

    public static void registerConnectionHandler(IConnectionHandler handler) {
        ForgeHooks.connectionHandlers.add(handler);
    }

    public static void registerChunkLoadHandler(IChunkLoadHandler handler) {
        ForgeHooks.chunkLoadHandlers.add(handler);
    }

    public static void registerPickupHandler(IPickupHandler handler) {
        ForgeHooks.pickupHandlers.add(handler);
    }

    public static void registerEntityInteractHandler(IEntityInteractHandler handler) {
        ForgeHooks.entityInteractHandlers.add(handler);
    }

    public static void registerChatHandler(IChatHandler handler) {
        ForgeHooks.chatHandlers.add(handler);
    }

    public static void registerSaveHandler(ISaveEventHandler handler) {
        ForgeHooks.saveHandlers.add(handler);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        ForgeHooks.fuelHandlers.add(handler);
    }

    @Deprecated
    public static void registerSpecialMobSpawnHandler(ISpecialMobSpawnHandler handler) {
        if (ne.class.getPackage() != null) {
            throw new RuntimeException("Still using deprecated method/interface MinecraftForge.registerSpecialModSpawnHandler()");
        }
        ForgeHooks.specialMobSpawnHandlers.add(handler);
    }

    public static void registerEntityLivingHandler(IEntityLivingHandler handler) {
        ForgeHooks.entityLivingHandlers.add(handler);
    }

    public static kp fillCustomBucket(ge world, int X, int Y, int Z) {
        for (IBucketHandler handler : bucketHandlers) {
            kp stack = handler.fillCustomBucket(world, X, Y, Z);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    @Deprecated
    public static void registerOreHandler(IOreHandler handler) {
        OreDictionary.registerOreHandler(handler);
    }

    @Deprecated
    public static void registerOre(String oreClass, kp ore) {
        OreDictionary.registerOre(oreClass, ore);
    }

    @Deprecated
    public static List<kp> getOreClass(String oreClass) {
        return OreDictionary.getOres(oreClass);
    }

    @Deprecated
    public static OreQuery generateRecipes(Object ... pattern) {
        return new OreQuery(pattern);
    }

    public static void addGrassPlant(int blockID, int metadata, int probability) {
        ForgeHooks.addPlantGrass(blockID, metadata, probability);
    }

    public static void addGrassSeed(int itemID, int metadata, int quantity, int probability) {
        ForgeHooks.addGrassSeed(itemID, metadata, quantity, probability);
    }

    public static void setToolClass(id tool, String toolClass, int harvestLevel) {
        ForgeHooks.initTools();
        ForgeHooks.toolClasses.put(tool.bP, Arrays.asList(toolClass, harvestLevel));
    }

    public static void setBlockHarvestLevel(vz block, int metadata, String toolClass, int harvestLevel) {
        ForgeHooks.initTools();
        List<Serializable> key = Arrays.asList(block.bO, metadata, toolClass);
        ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
        ForgeHooks.toolEffectiveness.add(key);
    }

    public static void removeBlockEffectiveness(vz block, int metadata, String toolClass) {
        ForgeHooks.initTools();
        List<Serializable> key = Arrays.asList(block.bO, metadata, toolClass);
        ForgeHooks.toolEffectiveness.remove(key);
    }

    public static void setBlockHarvestLevel(vz block, String toolClass, int harvestLevel) {
        ForgeHooks.initTools();
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Serializable> key = Arrays.asList(block.bO, metadata, toolClass);
            ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
            ForgeHooks.toolEffectiveness.add(key);
        }
    }

    public static int getBlockHarvestLevel(vz block, int metadata, String toolClass) {
        ForgeHooks.initTools();
        List<Serializable> key = Arrays.asList(block.bO, metadata, toolClass);
        Integer harvestLevel = (Integer)ForgeHooks.toolHarvestLevels.get(key);
        if (harvestLevel == null) {
            return -1;
        }
        return harvestLevel;
    }

    public static void removeBlockEffectiveness(vz block, String toolClass) {
        ForgeHooks.initTools();
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Serializable> key = Arrays.asList(block.bO, metadata, toolClass);
            ForgeHooks.toolEffectiveness.remove(key);
        }
    }

    public static void killMinecraft(String mod, String message) {
        throw new RuntimeException(mod + ": " + message);
    }

    public static void versionDetect(String mod, int major, int minor, int revision) {
        if (major != 3) {
            MinecraftForge.killMinecraft(mod, "MinecraftForge Major Version Mismatch, expecting " + major + ".x.x");
        } else if (minor != 3) {
            if (minor > 3) {
                MinecraftForge.killMinecraft(mod, "MinecraftForge Too Old, need at least " + major + "." + minor + "." + revision);
            } else {
                System.out.println(mod + ": MinecraftForge minor version mismatch, expecting " + major + "." + minor + ".x, may lead to unexpected behavior");
            }
        } else if (revision > 7) {
            MinecraftForge.killMinecraft(mod, "MinecraftForge Too Old, need at least " + major + "." + minor + "." + revision);
        }
    }

    public static void versionDetectStrict(String mod, int major, int minor, int revision) {
        if (major != 3) {
            MinecraftForge.killMinecraft(mod, "MinecraftForge Major Version Mismatch, expecting " + major + ".x.x");
        } else if (minor != 3) {
            if (minor > 3) {
                MinecraftForge.killMinecraft(mod, "MinecraftForge Too Old, need at least " + major + "." + minor + "." + revision);
            } else {
                MinecraftForge.killMinecraft(mod, "MinecraftForge minor version mismatch, expecting " + major + "." + minor + ".x");
            }
        } else if (revision > 7) {
            MinecraftForge.killMinecraft(mod, "MinecraftForge Too Old, need at least " + major + "." + minor + "." + revision);
        }
    }

    public static String getVersionString() {
        return String.format("Minecraft Forge %d.%d.%d.%d", 3, 3, 7, 140);
    }

    public static void setDungeonLootTries(int number) {
        dungeonLootAttempts = number;
    }

    public static int getDungeonLootTries() {
        return dungeonLootAttempts;
    }

    public static float addDungeonMob(String name, float rarity) {
        if (rarity <= 0.0f) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (ObjectPair<Float, String> mob : dungeonMobs) {
            if (!name.equals(mob.getValue2())) continue;
            mob.setValue1(Float.valueOf(mob.getValue1().floatValue() + rarity));
            return mob.getValue1().floatValue();
        }
        dungeonMobs.add(new ObjectPair<Float, String>(Float.valueOf(rarity), name));
        return rarity;
    }

    public static float removeDungeonMob(String name) {
        for (ObjectPair<Float, String> mob : dungeonMobs) {
            if (!name.equals(name)) continue;
            dungeonMobs.remove(mob);
            return mob.getValue1().floatValue();
        }
        return 0.0f;
    }

    public static String getRandomDungeonMob(Random rand) {
        float maxRarity = 0.0f;
        for (ObjectPair<Float, String> mob : dungeonMobs) {
            maxRarity += mob.getValue1().floatValue();
        }
        float targetRarity = rand.nextFloat() * maxRarity;
        for (ObjectPair<Float, String> mob : dungeonMobs) {
            if (targetRarity < mob.getValue1().floatValue()) {
                return mob.getValue2();
            }
            targetRarity -= mob.getValue1().floatValue();
        }
        return "";
    }

    public static void addDungeonLoot(kp item, float rarity) {
        MinecraftForge.addDungeonLoot(item, rarity, 1, 1);
    }

    public static float addDungeonLoot(kp item, float rarity, int minCount, int maxCount) {
        for (ObjectPair<Float, DungeonLoot> loot : dungeonLoot) {
            if (!loot.getValue2().equals(item, minCount, maxCount)) continue;
            loot.setValue1(Float.valueOf(loot.getValue1().floatValue() + rarity));
            return loot.getValue1().floatValue();
        }
        dungeonLoot.add(new ObjectPair<Float, DungeonLoot>(Float.valueOf(rarity), new DungeonLoot(item, minCount, maxCount)));
        return rarity;
    }

    public static float removeDungeonLoot(kp item) {
        return MinecraftForge.removeDungeonLoot(item, -1, 0);
    }

    public static float removeDungeonLoot(kp item, int minCount, int maxCount) {
        float rarity = 0.0f;
        ArrayList lootTmp = (ArrayList)dungeonLoot.clone();
        if (minCount < 0) {
            for (ObjectPair loot : lootTmp) {
                if (!((DungeonLoot)loot.getValue2()).equals(item)) continue;
                dungeonLoot.remove(loot);
                rarity += ((Float)loot.getValue1()).floatValue();
            }
        } else {
            for (ObjectPair loot : lootTmp) {
                if (!((DungeonLoot)loot.getValue2()).equals(item, minCount, maxCount)) continue;
                dungeonLoot.remove(loot);
                rarity += ((Float)loot.getValue1()).floatValue();
            }
        }
        return rarity;
    }

    public static kp getRandomDungeonLoot(Random rand) {
        float maxRarity = 0.0f;
        for (ObjectPair<Float, DungeonLoot> loot : dungeonLoot) {
            maxRarity += loot.getValue1().floatValue();
        }
        float targetRarity = rand.nextFloat() * maxRarity;
        for (ObjectPair<Float, DungeonLoot> loot : dungeonLoot) {
            if (targetRarity < loot.getValue1().floatValue()) {
                return loot.getValue2().generateStack(rand);
            }
            targetRarity -= loot.getValue1().floatValue();
        }
        return null;
    }

    public static void registerAchievementPage(AchievementPage page) {
        if (MinecraftForge.getAchievementPage(page.getName()) != null) {
            throw new RuntimeException("Duplicate achievement page name \"" + page.getName() + "\"!");
        }
        achievementPages.add(page);
    }

    public static AchievementPage getAchievementPage(int index) {
        return achievementPages.get(index);
    }

    public static AchievementPage getAchievementPage(String name) {
        for (AchievementPage page : achievementPages) {
            if (!page.getName().equals(name)) continue;
            return page;
        }
        return null;
    }

    public static Set<AchievementPage> getAchievementPages() {
        return new HashSet<AchievementPage>(achievementPages);
    }

    public static boolean isAchievementInPages(pj achievement) {
        for (AchievementPage page : achievementPages) {
            if (!page.getAchievements().contains(achievement)) continue;
            return true;
        }
        return false;
    }

    public static void registerMinecart(Class<? extends aaw> cart, kp item) {
        MinecraftForge.registerMinecart(cart, 0, item);
    }

    public static void registerMinecart(Class<? extends aaw> minecart, int type, kp item) {
        MinecartKey key = new MinecartKey(minecart, type);
        itemForMinecart.put(key, item);
        minecartForItem.put(item, key);
    }

    public static void removeMinecart(Class<? extends aaw> minecart, int type) {
        MinecartKey key = new MinecartKey(minecart, type);
        kp item = itemForMinecart.remove(key);
        if (item != null) {
            minecartForItem.remove(item);
        }
    }

    public static kp getItemForCart(Class<? extends aaw> minecart) {
        return MinecraftForge.getItemForCart(minecart, 0);
    }

    public static kp getItemForCart(Class<? extends aaw> minecart, int type) {
        kp item = itemForMinecart.get(new MinecartKey(minecart, type));
        if (item == null) {
            return null;
        }
        return item.j();
    }

    public static kp getItemForCart(aaw cart) {
        return MinecraftForge.getItemForCart(cart.getClass(), cart.getMinecartType());
    }

    public static Class<? extends aaw> getCartClassForItem(kp item) {
        MinecartKey key = null;
        for (Map.Entry<kp, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.minecart;
        }
        return null;
    }

    public static int getCartTypeForItem(kp item) {
        MinecartKey key = null;
        for (Map.Entry<kp, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.type;
        }
        return -1;
    }

    public static Set<kp> getAllCartItems() {
        HashSet<kp> ret = new HashSet<kp>();
        for (kp item : minecartForItem.keySet()) {
            ret.add(item.j());
        }
        return ret;
    }

    public static boolean registerEntity(Class entityClass, NetworkMod mod, int ID, int range, int updateFrequency, boolean sendVelocityInfo) {
        if (ForgeHooks.entityTrackerMap.containsKey(entityClass)) {
            return false;
        }
        ForgeHooks.entityTrackerMap.put(entityClass, new EntityTrackerInfo(mod, ID, range, updateFrequency, sendVelocityInfo));
        return true;
    }

    public static EntityTrackerInfo getEntityTrackerInfo(tv entity, boolean checkSupers) {
        for (Map.Entry<Class, EntityTrackerInfo> entry : ForgeHooks.entityTrackerMap.entrySet()) {
            if (!entry.getKey().isInstance(entity) || checkSupers && entry.getKey() != entity.getClass()) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Class getEntityClass(int modID, int type) {
        for (Map.Entry<Class, EntityTrackerInfo> entry : ForgeHooks.entityTrackerMap.entrySet()) {
            EntityTrackerInfo info = entry.getValue();
            if (type != info.ID || modID != MinecraftForge.getModID(info.Mod)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static NetworkMod getModByID(int id2) {
        return ForgeHooks.networkMods.get(id2);
    }

    public static int getModID(NetworkMod mod) {
        for (Map.Entry<Integer, NetworkMod> entry : ForgeHooks.networkMods.entrySet()) {
            if (entry.getValue() != mod) continue;
            return entry.getKey();
        }
        return -1;
    }

    public static NetworkMod[] getNetworkMods() {
        ArrayList<NetworkMod> ret = new ArrayList<NetworkMod>();
        for (BaseMod mod : ModLoader.getLoadedMods()) {
            if (!(mod instanceof NetworkMod)) continue;
            ret.add((NetworkMod)mod);
        }
        return ret.toArray(new NetworkMod[0]);
    }

    public static void setGuiHandler(BaseMod mod, IGuiHandler handler) {
        ForgeHooks.guiHandlers.put(mod, handler);
    }

    public static IGuiHandler getGuiHandler(BaseMod mod) {
        return ForgeHooks.guiHandlers.get(mod);
    }

    public static void registerArrowNockHandler(IArrowNockHandler handler) {
        ForgeHooks.arrowNockHandlers.add(handler);
    }

    public static void registerArrowLooseHandler(IArrowLooseHandler handler) {
        ForgeHooks.arrowLooseHandlers.add(handler);
    }

    public static void sendPacket(qq net, lx packet) {
        ForgeHooks.getPacketHandler().sendPacket(net, packet);
    }

    public static void sendPacket(qq net, NetworkMod mod, short id2, byte[] data) {
        if (data == null) {
            data = new byte[]{};
        }
        if (data.length > 255) {
            throw new IllegalArgumentException(String.format("Data argument was to long, must not be longer then 255 bytes was %d", data.length));
        }
        ao pkt = new ao();
        pkt.a = (short)MinecraftForge.getModID(mod);
        pkt.b = id2;
        pkt.c = data;
        MinecraftForge.sendPacket(net, (lx)pkt);
    }

    public static void sendTileEntityPacket(qq net, int x2, short y, int z, byte action, int par1, int par2, int par3) {
        vp pkt = new vp();
        pkt.a = x2;
        pkt.b = y;
        pkt.c = z;
        pkt.d = action;
        pkt.e = par1;
        pkt.f = par2;
        pkt.g = par3;
        MinecraftForge.sendPacket(net, (lx)pkt);
    }

    public static boolean isClient() {
        if (isClient == -1) {
            try {
                Class.forName("net.minecraft.client.Minecraft", false, MinecraftForge.class.getClassLoader());
                isClient = 1;
            }
            catch (ClassNotFoundException e) {
                isClient = 0;
            }
        }
        return isClient == 1;
    }

    public static void initialize() {
        vz.t.getTextureFile();
        id.as.getTextureFile();
        vz filler = null;
        try {
            filler = (vz)vz.class.getConstructor(Integer.TYPE, na.class).newInstance(256, na.a);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (filler == null) {
            throw new RuntimeException("Could not create Forge filler block");
        }
        for (int x2 = 256; x2 < 4096; ++x2) {
            if (id.d[x2 - 256] == null) continue;
            vz.m[x2] = filler;
        }
    }

    static {
        MinecraftForge.addDungeonMob("Skeleton", 1.0f);
        MinecraftForge.addDungeonMob("Zombie", 2.0f);
        MinecraftForge.addDungeonMob("Spider", 1.0f);
        MinecraftForge.addDungeonLoot(new kp(id.az), 1.0f);
        MinecraftForge.addDungeonLoot(new kp(id.n), 1.0f, 1, 4);
        MinecraftForge.addDungeonLoot(new kp(id.T), 1.0f);
        MinecraftForge.addDungeonLoot(new kp(id.S), 1.0f, 1, 4);
        MinecraftForge.addDungeonLoot(new kp(id.L), 1.0f, 1, 4);
        MinecraftForge.addDungeonLoot(new kp(id.J), 1.0f, 1, 4);
        MinecraftForge.addDungeonLoot(new kp(id.av), 1.0f);
        MinecraftForge.addDungeonLoot(new kp(id.as), 0.01f);
        MinecraftForge.addDungeonLoot(new kp(id.aB), 0.5f, 1, 4);
        MinecraftForge.addDungeonLoot(new kp(id.bE), 0.05f);
        MinecraftForge.addDungeonLoot(new kp(id.bF), 0.05f);
        MinecraftForge.addDungeonLoot(new kp(id.aV, 1, 3), 1.0f);
        MinecraftForge.registerMinecart(aaw.class, 0, new kp(id.ay));
        MinecraftForge.registerMinecart(aaw.class, 1, new kp(id.aM));
        MinecraftForge.registerMinecart(aaw.class, 2, new kp(id.aN));
    }

    @Deprecated
    public static class OreQuery
    implements Iterable<Object[]> {
        Object[] proto;

        private OreQuery(Object[] pattern) {
            this.proto = pattern;
        }

        @Override
        public Iterator<Object[]> iterator() {
            return new OreQueryIterator();
        }

        public class OreQueryIterator
        implements Iterator<Object[]> {
            LinkedList itering = new LinkedList();
            LinkedList output = new LinkedList();

            private OreQueryIterator() {
                for (Object input : OreQuery.this.proto) {
                    if (input instanceof Collection) {
                        Iterator it = ((Collection)input).iterator();
                        if (!it.hasNext()) {
                            this.output = null;
                            break;
                        }
                        this.itering.addLast(it);
                        this.output.addLast(it.next());
                        continue;
                    }
                    this.itering.addLast(input);
                    this.output.addLast(input);
                }
            }

            @Override
            public boolean hasNext() {
                return this.output != null;
            }

            @Override
            public Object[] next() {
                Iterator it;
                Object[] tr2 = this.output.toArray();
                while (true) {
                    if (this.itering.size() == 0) {
                        this.output = null;
                        return tr2;
                    }
                    Object to = this.itering.getLast();
                    this.output.removeLast();
                    if (to instanceof Iterator && (it = (Iterator)to).hasNext()) break;
                    this.itering.removeLast();
                }
                this.output.addLast(it.next());
                for (int i = this.itering.size(); i < OreQuery.this.proto.length; ++i) {
                    if (OreQuery.this.proto[i] instanceof Collection) {
                        Iterator it2 = ((Collection)OreQuery.this.proto[i]).iterator();
                        if (!it2.hasNext()) {
                            this.output = null;
                            break;
                        }
                        this.itering.addLast(it2);
                        this.output.addLast(it2.next());
                        continue;
                    }
                    this.itering.addLast(OreQuery.this.proto[i]);
                    this.output.addLast(OreQuery.this.proto[i]);
                }
                return tr2;
            }

            @Override
            public void remove() {
            }
        }
    }
}

