/*
 * Decompiled with CFR 0.152.
 */
package forge.oredict;

import forge.IOreHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OreDictionary {
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<kp>> oreStacks = new HashMap();
    private static ArrayList<IOreHandler> oreHandlers = new ArrayList();

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id2) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id2 != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static ArrayList<kp> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static ArrayList<kp> getOres(Integer id2) {
        ArrayList<Object> val = oreStacks.get(id2);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id2, val);
        }
        return val;
    }

    public static void registerOreHandler(IOreHandler handler) {
        oreHandlers.add(handler);
        HashMap tmp = (HashMap)oreIDs.clone();
        for (Map.Entry entry : tmp.entrySet()) {
            for (kp stack : OreDictionary.getOres((Integer)entry.getValue())) {
                handler.registerOre((String)entry.getKey(), stack);
            }
        }
    }

    public static void registerOre(String name, id ore) {
        OreDictionary.registerOre(name, new kp(ore));
    }

    public static void registerOre(String name, vz ore) {
        OreDictionary.registerOre(name, new kp(ore));
    }

    public static void registerOre(String name, kp ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id2, id ore) {
        OreDictionary.registerOre(id2, new kp(ore));
    }

    public static void registerOre(int id2, vz ore) {
        OreDictionary.registerOre(id2, new kp(ore));
    }

    public static void registerOre(int id2, kp ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id2), id2, ore);
    }

    private static void registerOre(String name, int id2, kp ore) {
        ArrayList<kp> ores = OreDictionary.getOres(id2);
        ore = ore.j();
        ores.add(ore);
        for (IOreHandler handler : oreHandlers) {
            handler.registerOre(name, ore);
        }
    }
}

