/*
 * Decompiled with CFR 0.152.
 */
package forge.oredict;

import forge.oredict.OreDictionary;
import java.util.ArrayList;
import java.util.HashMap;

public class ShapedOreRecipe
implements ev {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private kp output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirriored = true;

    public ShapedOreRecipe(vz result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(id result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(kp result, Object ... recipe) {
        this(result, true, recipe);
    }

    public ShapedOreRecipe(vz result, boolean mirrior, Object ... recipe) {
        this(new kp(result), mirrior, recipe);
    }

    public ShapedOreRecipe(id result, boolean mirrior, Object ... recipe) {
        this(new kp(result), mirrior, recipe);
    }

    public ShapedOreRecipe(kp result, boolean mirrior, Object ... recipe) {
        this.output = result.j();
        this.mirriored = mirrior;
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            Object val = null;
            if (in instanceof kp) {
                itemMap.put(chr, ((kp)in).j());
            } else if (in instanceof id) {
                itemMap.put(chr, new kp((id)in));
            } else if (in instanceof vz) {
                itemMap.put(chr, new kp((vz)in, 1, -1));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x2 = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x2++] = itemMap.get(Character.valueOf(chr));
        }
    }

    public kp b(nz var1) {
        return this.output.j();
    }

    public int a() {
        return this.input.length;
    }

    public kp b() {
        return this.output;
    }

    public boolean a(nz inv) {
        for (int x2 = 0; x2 <= 3 - this.width; ++x2) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x2, y, true)) {
                    return true;
                }
                if (!this.mirriored || !this.checkMatch(inv, x2, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(nz inv, int startX, int startY, boolean mirrior) {
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y = 0; y < 3; ++y) {
                int subX = x2 - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirrior ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                kp slot = inv.b(x2, y);
                if (target instanceof kp) {
                    if (this.checkItemEquals((kp)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (kp item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(kp target, kp input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.h() == -1 || target.h() == input.h());
    }

    public void setMirriored(boolean mirrior) {
        this.mirriored = mirrior;
    }
}

