/*
 * Decompiled with CFR 0.152.
 */
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.FMLTextureFX;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ModTextureAnimation
extends FMLTextureFX {
    private final int tickRate;
    private byte[][] images;
    private int index = 0;
    private int ticks = 0;
    private String targetTex = null;
    private BufferedImage imgData = null;

    public ModTextureAnimation(int icon, int target, BufferedImage image, int tickCount) {
        this(icon, 1, target, image, tickCount);
    }

    public ModTextureAnimation(int icon, int size, int target, BufferedImage image, int tickCount) {
        this(icon, size, target == 0 ? "/terrain.png" : "/gui/items.png", image, tickCount);
    }

    public ModTextureAnimation(int icon, int size, String target, BufferedImage image, int tickCount) {
        super(icon);
        avf re = FMLClientHandler.instance().getClient().o;
        this.targetTex = target;
        this.e = size;
        this.f = re.b(target);
        this.tickRate = tickCount;
        this.ticks = tickCount;
        this.imgData = image;
    }

    @Override
    public void setup() {
        super.setup();
        int sWidth = this.imgData.getWidth();
        int sHeight = this.imgData.getHeight();
        int tWidth = this.tileSizeBase;
        int tHeight = this.tileSizeBase;
        int frames = (int)Math.floor(sHeight / sWidth);
        if (frames < 1) {
            throw new IllegalArgumentException(String.format("Attempted to create a TextureAnimation with no complete frames: %dx%d", sWidth, sHeight));
        }
        this.images = new byte[frames][];
        BufferedImage image = this.imgData;
        if (sWidth != tWidth) {
            BufferedImage b = new BufferedImage(tWidth, tHeight * frames, 6);
            Graphics2D g = b.createGraphics();
            g.drawImage(this.imgData, 0, 0, tWidth, tHeight * frames, 0, 0, sWidth, sHeight, null);
            g.dispose();
            image = b;
        }
        for (int frame = 0; frame < frames; ++frame) {
            int[] pixels = new int[this.tileSizeSquare];
            image.getRGB(0, tHeight * frame, tWidth, tHeight, pixels, 0, tWidth);
            this.images[frame] = new byte[this.tileSizeSquare << 2];
            for (int i = 0; i < pixels.length; ++i) {
                int i4 = i * 4;
                this.images[frame][i4 + 0] = (byte)(pixels[i] >> 16 & 0xFF);
                this.images[frame][i4 + 1] = (byte)(pixels[i] >> 8 & 0xFF);
                this.images[frame][i4 + 2] = (byte)(pixels[i] >> 0 & 0xFF);
                this.images[frame][i4 + 3] = (byte)(pixels[i] >> 24 & 0xFF);
            }
        }
    }

    public void func_783_a() {
        if (++this.ticks >= this.tickRate) {
            if (++this.index >= this.images.length) {
                this.index = 0;
            }
            this.a = this.images[this.index];
            this.ticks = 0;
        }
    }
}

