/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.client.TextureFXManager;
import cpw.mods.fml.client.modloader.ModLoaderClientHelper;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private Minecraft client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;

    public void beginMinecraftLoading(Minecraft minecraft) {
        if (minecraft.q()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        this.client = minecraft;
        ObfuscationReflectionHelper.detectObfuscation(up.class);
        TextureFXManager.instance().setClient(this.client);
        FMLCommonHandler.instance().beginLoading(this);
        new ModLoaderClientHelper(this.client);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info")).getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        this.client.b(new a(message, t));
        throw Throwables.propagate((Throwable)t);
    }

    public void finishMinecraftLoading() {
        try {
            Loader.instance().initializeMods();
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
        LanguageRegistry.reloadLanguageTable();
        RenderingRegistry.instance().loadEntityRenderers(avy.a.o);
        KeyBindingRegistry.instance().uploadKeyBindingsToGame(this.client.y);
    }

    public void reloadTextureFX() {
        TextureFXManager.instance().loadTextures(this.client.C.e());
    }

    public Minecraft getClient() {
        return this.client;
    }

    public Logger getMinecraftLogger() {
        return null;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(og player, apn gui) {
        if (this.client.g == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return Collections.emptyList();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        apn gui = (apn)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public jn spawnEntityIntoClientWorld(Class<? extends jn> cls, EntitySpawnPacket packet) {
        atd wc = this.client.e;
        try {
            jn entity = cls.getConstructor(up.class).newInstance(wc);
            if (entity instanceof IThrowableEntity) {
                Object thrower = this.client.g.k == packet.throwerId ? this.client.g : wc.a(packet.throwerId);
                ((IThrowableEntity)((Object)entity)).setThrower((jn)thrower);
            }
            entity.ct = packet.rawX;
            entity.cu = packet.rawY;
            entity.cv = packet.rawZ;
            jn[] parts = entity.al();
            if (parts != null) {
                int i2 = packet.entityId - entity.k;
                for (int j2 = 0; j2 < parts.length; ++j2) {
                    parts[j2].k += i2;
                }
            }
            entity.k = packet.entityId;
            entity.a(packet.scaledX, packet.scaledY, packet.scaledZ, packet.scaledYaw, packet.scaledPitch, 1);
            if (entity instanceof jw) {
                ((jw)entity).as = packet.scaledHeadYaw;
            }
            if (packet.metadata != null) {
                entity.w().a(packet.metadata);
            }
            if (packet.throwerId > 0) {
                entity.h(packet.speedScaledX, packet.speedScaledY, packet.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)((Object)entity)).readSpawnData(packet.dataStream);
            }
            wc.a(packet.entityId, entity);
            return entity;
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket packet) {
        jn ent = this.client.e.a(packet.entityId);
        ent.ct = packet.serverX;
        ent.cu = packet.serverY;
        ent.cv = packet.serverZ;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.C();
    }

    @Override
    public void sendPacket(db packet) {
        this.client.g.a.c(packet);
    }
}

