/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private List<IScheduledTickHandler> scheduledClientTicks = Lists.newArrayList();
    private List<IScheduledTickHandler> scheduledServerTicks = Lists.newArrayList();
    private Class<?> forge;
    private boolean noForge;
    private List<String> brandings;

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        FMLLog.info("Attempting early MinecraftForge initialization", new Object[0]);
        this.callForgeMethod("initialize");
        FMLLog.info("Completed early MinecraftForge initialization", new Object[0]);
    }

    public void rescheduleTicks(Side side) {
        TickRegistry.updateTickQueue(side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks, side);
    }

    public void tickStart(EnumSet<TickType> ticks, Side side, Object ... data) {
        List<IScheduledTickHandler> scheduledTicks;
        List<IScheduledTickHandler> list = scheduledTicks = side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks;
        if (scheduledTicks.size() == 0) {
            return;
        }
        for (IScheduledTickHandler ticker : scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            ticker.tickStart(ticksToRun, data);
        }
    }

    public void tickEnd(EnumSet<TickType> ticks, Side side, Object ... data) {
        List<IScheduledTickHandler> scheduledTicks;
        List<IScheduledTickHandler> list = scheduledTicks = side.isClient() ? this.scheduledClientTicks : this.scheduledServerTicks;
        if (scheduledTicks.size() == 0) {
            return;
        }
        for (IScheduledTickHandler ticker : scheduledTicks) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            ticker.tickEnd(ticksToRun, data);
        }
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLCommonHandler.instance().getFMLLogger().throwing("FMLHandler", "raiseException", exception);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("net.minecraftforge.common.MinecraftForge");
            }
            catch (Exception ex) {
                this.noForge = true;
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getFMLVersionString());
            String forgeBranding = (String)this.callForgeMethod("getBrandingVersion");
            if (!Strings.isNullOrEmpty((String)forgeBranding)) {
                brd.add((Object)forgeBranding);
            }
            brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            try {
                Properties props = new Properties();
                props.load(this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties"));
                brd.add((Object)props.getProperty("fmlbranding"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
        }
    }

    public List<String> getBrandings() {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return ImmutableList.copyOf(this.brandings);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.tickEnd(EnumSet.of(TickType.SERVER), Side.SERVER, new Object[0]);
    }

    public void onPostWorldTick(Object world) {
        this.tickEnd(EnumSet.of(TickType.WORLD), Side.SERVER, world);
    }

    public void onPreServerTick() {
        this.tickStart(EnumSet.of(TickType.SERVER), Side.SERVER, new Object[0]);
    }

    public void onPreWorldTick(Object world) {
        this.tickStart(EnumSet.of(TickType.WORLD), Side.SERVER, world);
    }

    public void onWorldLoadTick(up[] worlds) {
        this.rescheduleTicks(Side.SERVER);
        for (up w : worlds) {
            this.tickStart(EnumSet.of(TickType.WORLDLOAD), Side.SERVER, w);
        }
    }

    public void handleServerStarting(MinecraftServer server) {
        Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public jn spawnEntityIntoClientWorld(Class<? extends jn> cls, EntitySpawnPacket entitySpawnPacket) {
        return this.sidedDelegate.spawnEntityIntoClientWorld(cls, entitySpawnPacket);
    }

    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket entitySpawnAdjustmentPacket) {
        this.sidedDelegate.adjustEntityLocationOnClient(entitySpawnAdjustmentPacket);
    }

    public void onServerStart(ft dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.tickStart(EnumSet.of(TickType.CLIENT), Side.CLIENT, new Object[0]);
    }

    public void onPostClientTick() {
        this.tickEnd(EnumSet.of(TickType.CLIENT), Side.CLIENT, new Object[0]);
    }

    public void onRenderTickStart(float timer) {
        this.tickStart(EnumSet.of(TickType.RENDER), Side.CLIENT, Float.valueOf(timer));
    }

    public void onRenderTickEnd(float timer) {
        this.tickEnd(EnumSet.of(TickType.RENDER), Side.CLIENT, Float.valueOf(timer));
    }

    public void onPlayerPreTick(og player) {
        Side side = player instanceof gu ? Side.SERVER : Side.CLIENT;
        this.tickStart(EnumSet.of(TickType.PLAYER), side, player);
    }

    public void onPlayerPostTick(og player) {
        Side side = player instanceof gu ? Side.SERVER : Side.CLIENT;
        this.tickEnd(EnumSet.of(TickType.PLAYER), side, player);
    }
}

