/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class FMLModContainer
implements ModContainer {
    private Mod modDescriptor;
    private Object modInstance;
    private File source;
    private ModMetadata modMetadata;
    private String className;
    private Map<String, Object> descriptor;
    private boolean enabled = true;
    private List<ArtifactVersion> requirements;
    private List<ArtifactVersion> dependencies;
    private List<ArtifactVersion> dependants;
    private boolean overridesMetadata;
    private EventBus eventBus;
    private LoadController controller;
    private Multimap<Class<? extends Annotation>, Object> annotations;
    private DefaultArtifactVersion processedVersion;
    private boolean isNetworkMod;
    private static final BiMap<Class<? extends FMLStateEvent>, Class<? extends Annotation>> modAnnotationTypes = ImmutableBiMap.builder().put(FMLPreInitializationEvent.class, Mod.PreInit.class).put(FMLInitializationEvent.class, Mod.Init.class).put(FMLPostInitializationEvent.class, Mod.PostInit.class).put(FMLServerStartingEvent.class, Mod.ServerStarting.class).put(FMLServerStartedEvent.class, Mod.ServerStarted.class).put(FMLServerStoppingEvent.class, Mod.ServerStopping.class).build();
    private static final BiMap<Class<? extends Annotation>, Class<? extends FMLStateEvent>> modTypeAnnotations = modAnnotationTypes.inverse();
    private String annotationDependencies;

    public FMLModContainer(String className, File modSource, Map<String, Object> modDescriptor) {
        this.className = className;
        this.source = modSource;
        this.descriptor = modDescriptor;
    }

    @Override
    public String getModId() {
        return (String)this.descriptor.get("modid");
    }

    @Override
    public String getName() {
        return this.modMetadata.name;
    }

    @Override
    public String getVersion() {
        return this.modMetadata.version;
    }

    @Override
    public File getSource() {
        return this.source;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.modMetadata;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) {
        this.modMetadata = mc.getMetadataForId(this.getModId(), this.descriptor);
        if (this.descriptor.containsKey("usesMetadata")) {
            boolean bl2 = this.overridesMetadata = (Boolean)this.descriptor.get("usesMetadata") == false;
        }
        if (this.overridesMetadata || !this.modMetadata.useDependencyInformation) {
            ArrayList requirements = Lists.newArrayList();
            ArrayList dependencies = Lists.newArrayList();
            ArrayList dependants = Lists.newArrayList();
            this.annotationDependencies = (String)this.descriptor.get("dependencies");
            Loader.instance().computeDependencies(this.annotationDependencies, requirements, dependencies, dependants);
            this.modMetadata.requiredMods = requirements;
            this.modMetadata.dependencies = dependencies;
            this.modMetadata.dependants = dependants;
        }
        if (Strings.isNullOrEmpty((String)this.modMetadata.name)) {
            this.modMetadata.name = this.getModId();
        }
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public List<ArtifactVersion> getRequirements() {
        return this.modMetadata.requiredMods;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.modMetadata.dependencies;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.modMetadata.dependants;
    }

    @Override
    public String getSortingRules() {
        return this.overridesMetadata ? this.annotationDependencies : this.modMetadata.printableSortingRules();
    }

    @Override
    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    @Override
    public Object getMod() {
        return this.modInstance;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            FMLLog.fine("Enabling mod %s", this.getModId());
            this.eventBus = bus;
            this.controller = controller;
            this.eventBus.register((Object)this);
            return true;
        }
        return false;
    }

    private Multimap<Class<? extends Annotation>, Object> gatherAnnotations(Class<?> clazz) throws Exception {
        ArrayListMultimap anns = ArrayListMultimap.create();
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation a2 : field.getAnnotations()) {
                field.setAccessible(true);
                anns.put(a2.annotationType(), (Object)field);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            for (Annotation a2 : accessibleObject.getAnnotations()) {
                if (!modTypeAnnotations.containsKey(a2.annotationType())) continue;
                Object[] paramTypes = new Class[]{(Class)modTypeAnnotations.get(a2.annotationType())};
                if (Arrays.equals(((Method)accessibleObject).getParameterTypes(), paramTypes)) {
                    ((Method)accessibleObject).setAccessible(true);
                    anns.put(a2.annotationType(), (Object)accessibleObject);
                    continue;
                }
                FMLLog.severe("The mod %s appears to have an invalid method annotation %s. This annotation can only apply to methods with argument types %s -it will not be called", this.getModId(), a2.annotationType().getSimpleName(), Arrays.toString(paramTypes));
            }
        }
        return anns;
    }

    private void processFieldAnnotations() throws Exception {
        Field f;
        for (Object o2 : this.annotations.get(Mod.Instance.class)) {
            f = (Field)o2;
            f.set(this.modInstance, this.modInstance);
        }
        for (Object o2 : this.annotations.get(Mod.Metadata.class)) {
            f = (Field)o2;
            f.set(this.modInstance, this.modMetadata);
        }
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.source);
            Class<?> clazz = Class.forName(this.className, true, modClassLoader);
            ASMDataTable asmHarvestedAnnotations = event.getASMHarvestedData();
            asmHarvestedAnnotations.getAnnotationsFor(this);
            this.annotations = this.gatherAnnotations(clazz);
            this.isNetworkMod = FMLNetworkHandler.instance().registerNetworkMod(this, clazz, event.getASMHarvestedData());
            this.modInstance = clazz.newInstance();
            ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide());
            this.processFieldAnnotations();
        }
        catch (Throwable e) {
            this.controller.errorOccurred(this, e);
            Throwables.propagateIfPossible((Throwable)e);
        }
    }

    @Subscribe
    public void handleModStateEvent(FMLStateEvent event) {
        Class annotation = (Class)modAnnotationTypes.get(event.getClass());
        if (annotation == null) {
            return;
        }
        try {
            for (Object o2 : this.annotations.get((Object)annotation)) {
                Method m = (Method)o2;
                m.invoke(this.modInstance, event);
            }
        }
        catch (Throwable t) {
            this.controller.errorOccurred(this, t);
            Throwables.propagateIfPossible((Throwable)t);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.getModId(), this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isNetworkMod() {
        return this.isNetworkMod;
    }
}

