/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = ArrayListMultimap.create();
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    private Map<String, ModContainer> modList;
    private List<ModContainer> activeModList = Lists.newArrayList();
    private String activeContainer;
    private BiMap<ModContainer, Object> modObjectList;

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus("FMLMainChannel");
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        this.modList = this.loader.getIndexedModList();
        ImmutableMap.Builder eventBus = ImmutableMap.builder();
        for (ModContainer mod : this.loader.getModList()) {
            EventBus bus;
            boolean isActive = mod.registerBus(bus = new EventBus(mod.getModId()), this);
            if (isActive) {
                FMLLog.fine("Activating mod %s", mod.getModId());
                this.activeModList.add(mod);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
                eventBus.put((Object)mod.getModId(), (Object)bus);
                continue;
            }
            FMLLog.warning("Mod %s has been disabled through configuration", mod.getModId());
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.DISABLED);
        }
        this.eventChannels = eventBus.build();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState) {
        LoaderState oldState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState) {
            FMLLog.severe("Fatal errors were detected during the transition from %s to %s. Loading cannot continue", new Object[]{oldState, desiredState});
            StringBuilder sb2 = new StringBuilder();
            this.printModStates(sb2);
            FMLLog.severe(sb2.toString(), new Object[0]);
            FMLLog.severe("The following problems were captured during this phase", new Object[0]);
            for (Map.Entry error : this.errors.entries()) {
                FMLLog.log(Level.SEVERE, (Throwable)error.getValue(), "Caught exception from %s", error.getKey());
            }
            throw new LoaderException((Throwable)this.errors.values().iterator().next());
        }
    }

    public ModContainer activeContainer() {
        return this.activeContainer != null ? this.modList.get(this.activeContainer) : null;
    }

    @Subscribe
    public void propogateStateMessage(FMLStateEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        for (Map.Entry entry : this.eventChannels.entrySet()) {
            this.activeContainer = (String)entry.getKey();
            stateEvent.applyModContainer(this.activeContainer());
            FMLLog.finer("Posting state event %s to mod %s", stateEvent, entry.getKey());
            ((EventBus)entry.getValue()).post((Object)stateEvent);
            FMLLog.finer("State event %s delivered to mod %s", stateEvent, entry.getKey());
            this.activeContainer = null;
            if (!this.errors.containsKey(entry.getKey())) {
                this.modStates.put(entry.getKey(), (Object)stateEvent.getModState());
                continue;
            }
            this.modStates.put(entry.getKey(), (Object)LoaderState.ModState.ERRORED);
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc : this.activeModList) {
            if (!mc.isImmutable() && mc.getMod() != null) {
                builder.put((Object)mc, mc.getMod());
            }
            if (mc.getMod() != null || mc.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe("There is a severe problem with %s - it appears not to have constructed correctly", mc.getModId());
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(mc, new RuntimeException());
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        this.errors.put((Object)modContainer.getModId(), (Object)exception);
    }

    public void printModStates(StringBuilder ret) {
        for (String modId : this.modStates.keySet()) {
            ModContainer mod = this.modList.get(modId);
            ret.append("\n\t").append(mod.getName()).append(" (").append(mod.getSource().getName()).append(") ");
            Joiner.on((String)"->").appendTo(ret, (Iterable)this.modStates.get((Object)modId));
        }
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return (LoaderState.ModState)((Object)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)((Object)LoaderState.ModState.AVAILABLE)));
    }

    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception e) {
            FMLLog.log(Level.SEVERE, e, "An unexpected exception", new Object[0]);
            throw new LoaderException(e);
        }
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe("Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }
}

