/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import argo.jdom.JsonNode;
import argo.jdom.JsonNodeBuilders;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.functions.ModNameFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ModMetadata {
    public String modId;
    public String name;
    public String description;
    public String url = "";
    public String updateUrl = "";
    public String logoFile = "";
    public String version = "";
    public List<String> authorList = Lists.newArrayList();
    public String credits = "";
    public String parent = "";
    public String[] screenshots;
    public ModContainer parentMod;
    public List<ModContainer> childMods = Lists.newArrayList();
    public boolean useDependencyInformation;
    public List<ArtifactVersion> requiredMods;
    public List<ArtifactVersion> dependencies;
    public List<ArtifactVersion> dependants;
    public boolean autogenerated;

    public ModMetadata(JsonNode node) {
        Map processedFields = Maps.transformValues((Map)node.getFields(), (Function)new JsonStringConverter());
        this.modId = (String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"modid"));
        if (Strings.isNullOrEmpty((String)this.modId)) {
            FMLLog.log(Level.SEVERE, "Found an invalid mod metadata file - missing modid", new Object[0]);
            throw new LoaderException();
        }
        this.name = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"name"))));
        this.description = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"description"))));
        this.url = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"url"))));
        this.updateUrl = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"updateUrl"))));
        this.logoFile = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"logoFile"))));
        this.version = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"version"))));
        this.credits = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"credits"))));
        this.parent = Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"parent"))));
        this.authorList = (List)Optional.fromNullable((Object)((List)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"authorList")))).or(this.authorList);
        this.requiredMods = this.processReferences((List)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"requiredMods")));
        this.dependencies = this.processReferences((List)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"dependencies")));
        this.dependants = this.processReferences((List)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"dependants")));
        this.useDependencyInformation = Boolean.parseBoolean(Strings.nullToEmpty((String)((String)processedFields.get(JsonNodeBuilders.aStringBuilder((String)"useDependencyInformation")))));
    }

    public ModMetadata() {
    }

    private List<ArtifactVersion> processReferences(List<String> refs) {
        ArrayList res = Lists.newArrayList();
        if (refs == null) {
            return res;
        }
        for (String ref : refs) {
            res.add(VersionParser.parseVersionReference(ref));
        }
        return res;
    }

    public String getChildModCountString() {
        return String.format("%d child mod%s", this.childMods.size(), this.childMods.size() != 1 ? "s" : "");
    }

    public String getAuthorList() {
        return Joiner.on((String)", ").join(this.authorList);
    }

    public String getChildModList() {
        return Joiner.on((String)", ").join((Iterable)Lists.transform(this.childMods, (Function)new ModNameFunction()));
    }

    public String printableSortingRules() {
        return "";
    }

    private static final class JsonArrayConverter
    implements Function<JsonNode, String> {
        private JsonArrayConverter() {
        }

        public String apply(JsonNode arg0) {
            return arg0.getText();
        }
    }

    private static final class JsonStringConverter
    implements Function<JsonNode, Object> {
        private JsonStringConverter() {
        }

        public Object apply(JsonNode arg0) {
            if (arg0.hasElements()) {
                return Lists.transform((List)arg0.getElements(), (Function)new JsonArrayConverter());
            }
            return arg0.getText();
        }
    }
}

