/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarDiscoverer
implements ITypeDiscoverer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList foundMods = Lists.newArrayList();
        FMLLog.fine("Examining file %s for potential mods", candidate.getModContainer().getName());
        ZipFile jar = null;
        try {
            jar = new ZipFile(candidate.getModContainer());
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            MetadataCollection mc = null;
            if (modInfo != null) {
                FMLLog.finer("Located mcmod.info file in file %s", candidate.getModContainer().getName());
                mc = MetadataCollection.from(jar.getInputStream(modInfo));
            } else {
                FMLLog.info("The mod container %s appears to be missing an mcmod.info file", candidate.getModContainer().getName());
                mc = MetadataCollection.from(null);
            }
            for (ZipEntry zipEntry : Collections.list(jar.entries())) {
                Matcher match = classFile.matcher(zipEntry.getName());
                if (!match.matches()) continue;
                ASMModParser modParser = new ASMModParser(jar.getInputStream(zipEntry));
                modParser.validate();
                modParser.sendToTable(table, candidate);
                ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
                if (container == null) continue;
                table.addContainer(container);
                foundMods.add(container);
                container.bindMetadata(mc);
            }
        }
        catch (Exception e) {
            FMLLog.log(Level.WARNING, e, "Zip file %s failed to read properly, it will be ignored", candidate.getModContainer().getName());
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {}
            }
        }
        return foundMods;
    }
}

