/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.event;

import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.io.File;

public class FMLPreInitializationEvent
extends FMLStateEvent {
    private ModMetadata modMetadata;
    private File sourceFile;
    private File configurationDir;
    private File suggestedConfigFile;
    private ASMDataTable asmData;

    public FMLPreInitializationEvent(Object ... data) {
        super(data);
        this.asmData = (ASMDataTable)data[0];
        this.configurationDir = (File)data[1];
    }

    @Override
    public LoaderState.ModState getModState() {
        return LoaderState.ModState.PREINITIALIZED;
    }

    @Override
    public void applyModContainer(ModContainer activeContainer) {
        this.modMetadata = activeContainer.getMetadata();
        this.sourceFile = activeContainer.getSource();
        this.suggestedConfigFile = new File(this.configurationDir, activeContainer.getModId() + ".cfg");
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public ModMetadata getModMetadata() {
        return this.modMetadata;
    }

    public File getModConfigurationDirectory() {
        return this.configurationDir;
    }

    public File getSuggestedConfigurationFile() {
        return this.suggestedConfigFile;
    }

    public ASMDataTable getAsmData() {
        return this.asmData;
    }
}

