/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.BaseModTicker;
import cpw.mods.fml.common.modloader.IModLoaderSidedHelper;
import cpw.mods.fml.common.modloader.ModLoaderConnectionHandler;
import cpw.mods.fml.common.modloader.ModLoaderCraftingHelper;
import cpw.mods.fml.common.modloader.ModLoaderFuelHelper;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.modloader.ModLoaderPacketHandler;
import cpw.mods.fml.common.modloader.ModLoaderPickupNotifier;
import cpw.mods.fml.common.modloader.ModLoaderWorldGenerator;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ModLoaderHelper {
    private static Map<BaseMod, ModLoaderModContainer> notModCallbacks = new HashMap<BaseMod, ModLoaderModContainer>();
    public static IModLoaderSidedHelper sidedHelper;

    public static void updateStandardTicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)Loader.instance().activeModContainer();
        BaseModTicker ticker = mlmc.getGameTickHandler();
        EnumSet<TickType> ticks = ticker.ticks();
        if (enable && !useClock) {
            ticks.add(TickType.RENDER);
        } else {
            ticks.remove((Object)TickType.RENDER);
        }
        if (enable && (useClock || FMLCommonHandler.instance().getSide().isServer())) {
            ticks.add(TickType.CLIENT);
            ticks.add(TickType.WORLDLOAD);
        } else {
            ticks.remove((Object)TickType.CLIENT);
            ticks.remove((Object)TickType.WORLDLOAD);
        }
    }

    public static void updateGUITicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        EnumSet<TickType> ticks = mlmc.getGUITickHandler().ticks();
        if (enable && !useClock) {
            ticks.add(TickType.RENDER);
        } else {
            ticks.remove((Object)TickType.RENDER);
        }
        if (enable && useClock) {
            ticks.add(TickType.CLIENT);
            ticks.add(TickType.WORLDLOAD);
        } else {
            ticks.remove((Object)TickType.CLIENT);
            ticks.remove((Object)TickType.WORLDLOAD);
        }
    }

    private static ModLoaderModContainer findOrBuildModContainer(BaseMod mod) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)FMLCommonHandler.instance().findContainerFor(mod);
        if (mlmc == null && (mlmc = notModCallbacks.get(mod)) == null) {
            mlmc = new ModLoaderModContainer(mod);
            notModCallbacks.put(mod, mlmc);
        }
        return mlmc;
    }

    public static ModLoaderModContainer registerKeyHelper(BaseMod mod) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        return mlmc;
    }

    public static IPacketHandler buildPacketHandlerFor(BaseMod mod) {
        return new ModLoaderPacketHandler(mod);
    }

    public static IWorldGenerator buildWorldGenHelper(BaseModProxy mod) {
        return new ModLoaderWorldGenerator(mod);
    }

    public static IFuelHandler buildFuelHelper(BaseModProxy mod) {
        return new ModLoaderFuelHelper(mod);
    }

    public static ICraftingHandler buildCraftingHelper(BaseModProxy mod) {
        return new ModLoaderCraftingHelper(mod);
    }

    public static void finishModLoading(ModLoaderModContainer mc) {
        if (sidedHelper != null) {
            sidedHelper.finishModLoading(mc);
        }
    }

    public static IConnectionHandler buildConnectionHelper(BaseModProxy mod) {
        return new ModLoaderConnectionHandler(mod);
    }

    public static IPickupNotifier buildPickupHelper(BaseModProxy mod) {
        return new ModLoaderPickupNotifier(mod);
    }
}

