/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.modloader.BaseModProxy;
import cpw.mods.fml.common.modloader.BaseModTicker;
import cpw.mods.fml.common.modloader.ModLoaderHelper;
import cpw.mods.fml.common.modloader.ModProperty;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class ModLoaderModContainer
implements ModContainer {
    public BaseModProxy mod;
    private File modSource;
    public List<ArtifactVersion> requirements = Lists.newArrayList();
    public ArrayList<ArtifactVersion> dependencies = Lists.newArrayList();
    public ArrayList<ArtifactVersion> dependants = Lists.newArrayList();
    private ContainerType sourceType;
    private ModMetadata metadata;
    private ProxyInjector sidedProxy;
    private BaseModTicker gameTickHandler;
    private BaseModTicker guiTickHandler;
    private String modClazzName;
    private String modId;
    private EventBus bus;
    private LoadController controller;
    private boolean enabled = true;
    private String sortingProperties;
    private ArtifactVersion processedVersion;
    private boolean isNetworkMod;

    public ModLoaderModContainer(String className, File modSource, String sortingProperties) {
        this.modClazzName = className;
        this.modSource = modSource;
        this.modId = className.contains(".") ? className.substring(className.lastIndexOf(46) + 1) : className;
        this.sortingProperties = Strings.isNullOrEmpty((String)sortingProperties) ? "" : sortingProperties;
    }

    ModLoaderModContainer(BaseModProxy instance) {
        this.mod = instance;
        this.gameTickHandler = new BaseModTicker(instance, false);
        this.guiTickHandler = new BaseModTicker(instance, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureMod(Class<? extends BaseModProxy> modClazz, ASMDataTable asmData) {
        StringBuffer comments;
        boolean mlPropFound;
        boolean existingConfigFound;
        Properties props;
        File modConfig;
        block34: {
            File configDir = Loader.instance().getConfigDir();
            modConfig = new File(configDir, String.format("%s.cfg", this.modClazzName));
            props = new Properties();
            existingConfigFound = false;
            mlPropFound = false;
            if (modConfig.exists()) {
                try {
                    FMLLog.fine("Reading existing configuration file for %s : %s", this.modClazzName, modConfig.getName());
                    FileReader configReader = new FileReader(modConfig);
                    props.load(configReader);
                    configReader.close();
                }
                catch (Exception e) {
                    FMLLog.log(Level.SEVERE, e, "Error occured reading mod configuration file %s", modConfig.getName());
                    throw new LoaderException(e);
                }
                existingConfigFound = true;
            }
            comments = new StringBuffer();
            comments.append("MLProperties: name (type:default) min:max -- information\n");
            ArrayList mlPropFields = Lists.newArrayList();
            try {
                for (ASMDataTable.ASMData dat : Sets.union((Set)asmData.getAnnotationsFor(this).get((Object)"net.minecraft.src.MLProp"), (Set)asmData.getAnnotationsFor(this).get((Object)"MLProp"))) {
                    if (!dat.getClassName().equals(this.modClazzName)) continue;
                    try {
                        mlPropFields.add(new ModProperty(modClazz.getDeclaredField(dat.getObjectName()), dat.getAnnotationInfo()));
                    }
                    catch (Exception e) {
                        FMLLog.log(Level.WARNING, e, "An error occured trying to access field %s in mod %s", dat.getObjectName(), this.getModId());
                    }
                }
                for (ModProperty property : mlPropFields) {
                    Object defaultValue;
                    String propertyValue;
                    String propertyName;
                    Field f;
                    block33: {
                        if (!Modifier.isStatic(property.field().getModifiers())) {
                            FMLLog.info("The MLProp field %s in mod %s appears not to be static", property.field().getName(), this.getModId());
                            continue;
                        }
                        f = property.field();
                        propertyName = property.name().length() > 0 ? property.name() : f.getName();
                        propertyValue = null;
                        defaultValue = null;
                        try {
                            defaultValue = f.get(null);
                            propertyValue = props.getProperty(propertyName, this.extractValue(defaultValue));
                            Object currentValue = this.parseValue(propertyValue, property, f.getType(), propertyName, this.modClazzName);
                            FMLLog.finest("Configuration for %s.%s found values default: %s, configured: %s, interpreted: %s", this.modClazzName, propertyName, defaultValue, propertyValue, currentValue);
                            if (currentValue == null || currentValue.equals(defaultValue)) break block33;
                            FMLLog.finest("Configuration for %s.%s value set to: %s", this.modClazzName, propertyName, currentValue);
                            f.set(null, currentValue);
                        }
                        catch (Exception e) {
                            try {
                                FMLLog.log(Level.SEVERE, e, "Invalid configuration found for %s in %s", propertyName, modConfig.getName());
                                throw new LoaderException(e);
                            }
                            catch (Throwable throwable) {
                                comments.append(String.format("MLProp : %s (%s:%s", propertyName, f.getType().getName(), defaultValue));
                                if (property.min() != Double.MIN_VALUE) {
                                    comments.append(",>=").append(String.format("%.1f", property.min()));
                                }
                                if (property.max() != Double.MAX_VALUE) {
                                    comments.append(",<=").append(String.format("%.1f", property.max()));
                                }
                                comments.append(")");
                                if (property.info().length() > 0) {
                                    comments.append(" -- ").append(property.info());
                                }
                                if (propertyValue != null) {
                                    props.setProperty(propertyName, this.extractValue(propertyValue));
                                }
                                comments.append("\n");
                                throw throwable;
                            }
                        }
                    }
                    comments.append(String.format("MLProp : %s (%s:%s", propertyName, f.getType().getName(), defaultValue));
                    if (property.min() != Double.MIN_VALUE) {
                        comments.append(",>=").append(String.format("%.1f", property.min()));
                    }
                    if (property.max() != Double.MAX_VALUE) {
                        comments.append(",<=").append(String.format("%.1f", property.max()));
                    }
                    comments.append(")");
                    if (property.info().length() > 0) {
                        comments.append(" -- ").append(property.info());
                    }
                    if (propertyValue != null) {
                        props.setProperty(propertyName, this.extractValue(propertyValue));
                    }
                    comments.append("\n");
                    mlPropFound = true;
                }
                if (mlPropFound || existingConfigFound) break block34;
            }
            catch (Throwable throwable) {
                if (!mlPropFound && !existingConfigFound) {
                    FMLLog.fine("No MLProp configuration for %s found or required. No file written", this.modClazzName);
                    return;
                }
                if (!mlPropFound && existingConfigFound) {
                    File mlPropBackup = new File(modConfig.getParent(), modConfig.getName() + ".bak");
                    FMLLog.fine("MLProp configuration file for %s found but not required. Attempting to rename file to %s", this.modClazzName, mlPropBackup.getName());
                    boolean renamed = modConfig.renameTo(mlPropBackup);
                    if (renamed) {
                        FMLLog.fine("Unused MLProp configuration file for %s renamed successfully to %s", this.modClazzName, mlPropBackup.getName());
                    } else {
                        FMLLog.fine("Unused MLProp configuration file for %s renamed UNSUCCESSFULLY to %s", this.modClazzName, mlPropBackup.getName());
                    }
                    return;
                }
                try {
                    FileWriter configWriter = new FileWriter(modConfig);
                    props.store(configWriter, comments.toString());
                    configWriter.close();
                    FMLLog.fine("Configuration for %s written to %s", this.modClazzName, modConfig.getName());
                }
                catch (IOException e) {
                    FMLLog.log(Level.SEVERE, e, "Error trying to write the config file %s", modConfig.getName());
                    throw new LoaderException(e);
                }
                throw throwable;
            }
            FMLLog.fine("No MLProp configuration for %s found or required. No file written", this.modClazzName);
            return;
        }
        if (!mlPropFound && existingConfigFound) {
            File mlPropBackup = new File(modConfig.getParent(), modConfig.getName() + ".bak");
            FMLLog.fine("MLProp configuration file for %s found but not required. Attempting to rename file to %s", this.modClazzName, mlPropBackup.getName());
            boolean renamed = modConfig.renameTo(mlPropBackup);
            if (renamed) {
                FMLLog.fine("Unused MLProp configuration file for %s renamed successfully to %s", this.modClazzName, mlPropBackup.getName());
            } else {
                FMLLog.fine("Unused MLProp configuration file for %s renamed UNSUCCESSFULLY to %s", this.modClazzName, mlPropBackup.getName());
            }
            return;
        }
        try {
            FileWriter configWriter = new FileWriter(modConfig);
            props.store(configWriter, comments.toString());
            configWriter.close();
            FMLLog.fine("Configuration for %s written to %s", this.modClazzName, modConfig.getName());
        }
        catch (IOException e) {
            FMLLog.log(Level.SEVERE, e, "Error trying to write the config file %s", modConfig.getName());
            throw new LoaderException(e);
        }
    }

    private Object parseValue(String val, ModProperty property, Class<?> type, String propertyName, String modConfigName) {
        if (type.isAssignableFrom(String.class)) {
            return val;
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean(val);
        }
        if (Number.class.isAssignableFrom(type) || type.isPrimitive()) {
            Number n2 = null;
            if (type.isAssignableFrom(Double.TYPE) || Double.class.isAssignableFrom(type)) {
                n2 = Double.parseDouble(val);
            } else if (type.isAssignableFrom(Float.TYPE) || Float.class.isAssignableFrom(type)) {
                n2 = Float.valueOf(Float.parseFloat(val));
            } else if (type.isAssignableFrom(Long.TYPE) || Long.class.isAssignableFrom(type)) {
                n2 = Long.parseLong(val);
            } else if (type.isAssignableFrom(Integer.TYPE) || Integer.class.isAssignableFrom(type)) {
                n2 = Integer.parseInt(val);
            } else if (type.isAssignableFrom(Short.TYPE) || Short.class.isAssignableFrom(type)) {
                n2 = Short.parseShort(val);
            } else if (type.isAssignableFrom(Byte.TYPE) || Byte.class.isAssignableFrom(type)) {
                n2 = Byte.parseByte(val);
            } else {
                throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", propertyName, type.getName()));
            }
            if (n2.doubleValue() < property.min() || n2.doubleValue() > property.max()) {
                FMLLog.warning("Configuration for %s.%s found value %s outside acceptable range %s,%s", modConfigName, propertyName, n2, property.min(), property.max());
                return null;
            }
            return n2;
        }
        throw new IllegalArgumentException(String.format("MLProp declared on %s of type %s, an unsupported type", propertyName, type.getName()));
    }

    private String extractValue(Object value) {
        if (String.class.isInstance(value)) {
            return (String)value;
        }
        if (Number.class.isInstance(value) || Boolean.class.isInstance(value)) {
            return String.valueOf(value);
        }
        throw new IllegalArgumentException("MLProp declared on non-standard type");
    }

    @Override
    public String getName() {
        return this.mod != null ? this.mod.getName() : this.modId;
    }

    @Deprecated
    public static ModContainer findContainerFor(BaseModProxy mod) {
        return FMLCommonHandler.instance().findContainerFor(mod);
    }

    @Override
    public String getSortingRules() {
        return this.sortingProperties;
    }

    @Override
    public boolean matches(Object mod) {
        return this.mod == mod;
    }

    public static <A extends BaseModProxy> List<A> findAll(Class<A> clazz) {
        ArrayList<BaseModProxy> modList = new ArrayList<BaseModProxy>();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            if (!(mc instanceof ModLoaderModContainer) || mc.getMod() == null) continue;
            modList.add(((ModLoaderModContainer)mc).mod);
        }
        return modList;
    }

    @Override
    public File getSource() {
        return this.modSource;
    }

    @Override
    public Object getMod() {
        return this.mod;
    }

    @Override
    public List<ArtifactVersion> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<ArtifactVersion> getDependants() {
        return this.dependants;
    }

    @Override
    public List<ArtifactVersion> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return this.modId;
    }

    @Override
    public ModMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getVersion() {
        if (this.mod == null || this.mod.getVersion() == null) {
            return "Not available";
        }
        return this.mod.getVersion();
    }

    public BaseModTicker getGameTickHandler() {
        return this.gameTickHandler;
    }

    public BaseModTicker getGUITickHandler() {
        return this.guiTickHandler;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public void bindMetadata(MetadataCollection mc) {
        ImmutableMap dummyMetadata = ImmutableMap.builder().put((Object)"name", (Object)this.modId).put((Object)"version", (Object)"").build();
        this.metadata = mc.getMetadataForId(this.modId, (Map<String, Object>)dummyMetadata);
        Loader.instance().computeDependencies(this.sortingProperties, this.getRequirements(), this.getDependencies(), this.getDependants());
    }

    @Override
    public void setEnabledState(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        if (this.enabled) {
            FMLLog.fine("Enabling mod %s", this.getModId());
            this.bus = bus;
            this.controller = controller;
            bus.register((Object)this);
            return true;
        }
        return false;
    }

    @Subscribe
    public void constructMod(FMLConstructionEvent event) {
        try {
            ModClassLoader modClassLoader = event.getModClassLoader();
            modClassLoader.addFile(this.modSource);
            EnumSet<TickType> ticks = EnumSet.noneOf(TickType.class);
            this.gameTickHandler = new BaseModTicker(ticks, false);
            this.guiTickHandler = new BaseModTicker((EnumSet<TickType>)ticks.clone(), true);
            Class<?> modClazz = Class.forName(this.modClazzName, true, modClassLoader);
            this.configureMod(modClazz, event.getASMHarvestedData());
            this.isNetworkMod = FMLNetworkHandler.instance().registerNetworkMod(this, modClazz, event.getASMHarvestedData());
            this.mod = (BaseModProxy)modClazz.newInstance();
            ProxyInjector.inject(this, event.getASMHarvestedData(), FMLCommonHandler.instance().getSide());
        }
        catch (Exception e) {
            this.controller.errorOccurred(this, e);
            Throwables.propagateIfPossible((Throwable)e);
        }
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        try {
            this.gameTickHandler.setMod(this.mod);
            this.guiTickHandler.setMod(this.mod);
            TickRegistry.registerTickHandler(this.gameTickHandler, Side.CLIENT);
            TickRegistry.registerTickHandler(this.guiTickHandler, Side.CLIENT);
            GameRegistry.registerWorldGenerator(ModLoaderHelper.buildWorldGenHelper(this.mod));
            GameRegistry.registerFuelHandler(ModLoaderHelper.buildFuelHelper(this.mod));
            GameRegistry.registerCraftingHandler(ModLoaderHelper.buildCraftingHelper(this.mod));
            GameRegistry.registerPickupHandler(ModLoaderHelper.buildPickupHelper(this.mod));
            NetworkRegistry.instance().registerConnectionHandler(ModLoaderHelper.buildConnectionHelper(this.mod));
        }
        catch (Exception e) {
            this.controller.errorOccurred(this, e);
            Throwables.propagateIfPossible((Throwable)e);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        try {
            this.mod.load();
        }
        catch (Throwable t) {
            this.controller.errorOccurred(this, t);
            Throwables.propagateIfPossible((Throwable)t);
        }
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        try {
            this.mod.modsLoaded();
        }
        catch (Throwable t) {
            this.controller.errorOccurred(this, t);
            Throwables.propagateIfPossible((Throwable)t);
        }
    }

    @Override
    public ArtifactVersion getProcessedVersion() {
        if (this.processedVersion == null) {
            this.processedVersion = new DefaultArtifactVersion(this.modId, this.getVersion());
        }
        return this.processedVersion;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isNetworkMod() {
        return this.isNetworkMod;
    }
}

