/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLNetworkHandler {
    private static final int FML_HASH = Hashing.murmur3_32().hashString((CharSequence)"FML").asInt();
    private static final int PROTOCOL_VERSION = 1;
    private static final FMLNetworkHandler INSTANCE = new FMLNetworkHandler();
    private Map<gx, Integer> loginStates = Maps.newHashMap();
    private Map<ModContainer, NetworkModHandler> networkModHandlers = Maps.newHashMap();
    private Map<Integer, NetworkModHandler> networkIdLookup = Maps.newHashMap();

    public static void handlePacket250Packet(ce packet, az network, dc handler) {
        String target = packet.a;
        if (target.startsWith("MC|")) {
            handler.handleVanilla250Packet(packet);
        }
        if (target.equals("FML")) {
            FMLNetworkHandler.instance().handleFMLPacket(packet, network, handler);
        } else {
            NetworkRegistry.instance().handleCustomPacket(packet, network, handler);
        }
    }

    public static void onConnectionEstablishedToServer(dc clientHandler, az manager, cs login) {
        NetworkRegistry.instance().clientLoggedIn(clientHandler, manager, login);
    }

    private void handleFMLPacket(ce packet, az network, dc netHandler) {
        FMLPacket pkt = FMLPacket.readPacket(packet.c);
        String userName = "";
        if (netHandler instanceof gx) {
            userName = ((gx)netHandler).h;
        } else {
            og pl = netHandler.getPlayer();
            if (pl != null) {
                userName = pl.c_();
            }
        }
        pkt.execute(network, this, netHandler, userName);
    }

    public static void onConnectionReceivedFromClient(gx netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        FMLNetworkHandler.instance().handleClientConnection(netLoginHandler, server, address, userName);
    }

    private void handleClientConnection(gx netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        if (!this.loginStates.containsKey(netLoginHandler) && this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
            FMLLog.fine("Connection from %s rejected - no FML packet received from client", userName);
            netLoginHandler.completeConnection("You don't have FML installed, or your installation is too old");
            return;
        }
        if (this.loginStates.get(netLoginHandler) == 1) {
            String modKick = NetworkRegistry.instance().connectionReceived(netLoginHandler, netLoginHandler.b);
            if (modKick != null) {
                netLoginHandler.completeConnection(modKick);
                this.loginStates.remove(netLoginHandler);
                return;
            }
            if (!this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                this.loginStates.remove(netLoginHandler);
                return;
            }
            gx.a(netLoginHandler, false);
            netLoginHandler.b.a((db)this.getModListRequestPacket());
            this.loginStates.put(netLoginHandler, 2);
        } else if (this.loginStates.get(netLoginHandler) == 2) {
            netLoginHandler.completeConnection(null);
            this.loginStates.remove(netLoginHandler);
        } else {
            netLoginHandler.completeConnection("There was a problem during FML negotiation");
            this.loginStates.remove(netLoginHandler);
        }
    }

    private boolean handleVanillaLoginKick(gx netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        et playerList = server.ab();
        String kickReason = playerList.a(address, userName);
        if (kickReason != null) {
            netLoginHandler.completeConnection(kickReason);
        }
        return kickReason == null;
    }

    public static void handleLoginPacketOnServer(gx handler, cs login) {
        if (login.a == FML_HASH && login.e == 1) {
            FMLLog.finest("Received valid FML login packet from %s", handler.b.c());
            FMLNetworkHandler.instance().loginStates.put(handler, 1);
        } else {
            FMLLog.fine("Received invalid FML login packet %d, %d from %s", login.a, login.e, handler.b.c());
        }
    }

    public static FMLNetworkHandler instance() {
        return INSTANCE;
    }

    public static cs getFMLFakeLoginPacket() {
        cs fake = new cs();
        fake.a = FML_HASH;
        fake.e = 1;
        fake.d = uy.a;
        fake.b = va.a[0];
        return fake;
    }

    public ce getModListRequestPacket() {
        ce pkt = new ce();
        pkt.a = "FML";
        pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_REQUEST, new Object[0]);
        pkt.b = pkt.c.length;
        return pkt;
    }

    public void registerNetworkMod(NetworkModHandler handler) {
        this.networkModHandlers.put(handler.getContainer(), handler);
        this.networkIdLookup.put(handler.getNetworkId(), handler);
    }

    public boolean registerNetworkMod(ModContainer container, Class<?> networkModClass, ASMDataTable asmData) {
        NetworkModHandler handler = new NetworkModHandler(container, networkModClass, asmData);
        if (handler.isNetworkMod()) {
            this.registerNetworkMod(handler);
        }
        return handler.isNetworkMod();
    }

    public NetworkModHandler findNetworkModHandler(Object mc) {
        if (mc instanceof ModContainer) {
            return this.networkModHandlers.get(mc);
        }
        if (mc instanceof Integer) {
            return this.networkIdLookup.get(mc);
        }
        return this.networkModHandlers.get(FMLCommonHandler.instance().findContainerFor(mc));
    }

    public Set<ModContainer> getNetworkModList() {
        return this.networkModHandlers.keySet();
    }

    public static void handlePlayerLogin(gu player, gz netHandler, az manager) {
        NetworkRegistry.instance().playerLoggedIn(player, netHandler, manager);
    }

    public Map<Integer, NetworkModHandler> getNetworkIdMap() {
        return this.networkIdLookup;
    }

    public void bindNetworkId(String key, Integer value) {
        Map<String, ModContainer> mods = Loader.instance().getIndexedModList();
        NetworkModHandler handler = this.findNetworkModHandler(mods.get(key));
        handler.setNetworkId(value);
        this.networkIdLookup.put(value, handler);
    }

    public static void onClientConnectionToRemoteServer(dc netClientHandler, String server, int port, az networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, port, networkManager);
    }

    public static void onClientConnectionToIntegratedServer(dc netClientHandler, MinecraftServer server, az networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, networkManager);
    }

    public static void onConnectionClosed(az manager) {
        NetworkRegistry.instance().connectionClosed(manager);
    }

    public static void sendPacket(Player player, db packet) {
    }

    public static void openGui(og player, Object mod, int modGuiId, up world, int x, int y, int z) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
            if (nmh != null) {
                mc = nmh.getContainer();
            } else {
                FMLLog.warning("A mod tried to open a gui on the server without being a NetworkMod", new Object[0]);
                return;
            }
        }
        if (player instanceof gu) {
            NetworkRegistry.instance().openRemoteGui(mc, (gu)player, modGuiId, world, x, y, z);
        } else {
            NetworkRegistry.instance().openLocalGui(mc, player, modGuiId, world, x, y, z);
        }
    }

    public static db getEntitySpawningPacket(jn entity) {
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er2 == null) {
            return null;
        }
        ce pkt = new ce();
        pkt.a = "FML";
        pkt.c = FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWN, er2, entity, FMLNetworkHandler.instance().findNetworkModHandler(er2.getContainer()));
        pkt.b = pkt.c.length;
        return pkt;
    }

    public static void makeEntitySpawnAdjustment(int entityId, gu player, int serverX, int serverY, int serverZ) {
        ce pkt = new ce();
        pkt.a = "FML";
        pkt.c = FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWNADJUSTMENT, entityId, serverX, serverY, serverZ);
        pkt.b = pkt.c.length;
        player.a.b((db)pkt);
    }
}

