/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Throwables;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.ModIdentifiersPacket;
import cpw.mods.fml.common.network.ModListRequestPacket;
import cpw.mods.fml.common.network.ModListResponsePacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.network.OpenGuiPacket;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class FMLPacket {
    private Type type;

    public static byte[] makePacket(Type type, Object ... data) {
        byte[] packetData = type.make().generatePacket(data);
        return Bytes.concat((byte[][])new byte[][]{{UnsignedBytes.checkedCast((long)type.ordinal())}, packetData});
    }

    public static FMLPacket readPacket(byte[] payload) {
        int type = UnsignedBytes.toInt((byte)payload[0]);
        return Type.values()[type].make().consumePacket(Arrays.copyOfRange(payload, 1, payload.length));
    }

    public FMLPacket(Type type) {
        this.type = type;
    }

    public abstract byte[] generatePacket(Object ... var1);

    public abstract FMLPacket consumePacket(byte[] var1);

    public abstract void execute(az var1, FMLNetworkHandler var2, dc var3, String var4);

    static enum Type {
        MOD_LIST_REQUEST(ModListRequestPacket.class),
        MOD_LIST_RESPONSE(ModListResponsePacket.class),
        MOD_IDENTIFIERS(ModIdentifiersPacket.class),
        MOD_MISSING(ModMissingPacket.class),
        GUIOPEN(OpenGuiPacket.class),
        ENTITYSPAWN(EntitySpawnPacket.class),
        ENTITYSPAWNADJUSTMENT(EntitySpawnAdjustmentPacket.class);

        private Class<? extends FMLPacket> packetType;

        private Type(Class<? extends FMLPacket> clazz) {
            this.packetType = clazz;
        }

        FMLPacket make() {
            try {
                return this.packetType.newInstance();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e);
                FMLLog.log(Level.SEVERE, e, "A bizarre critical error occured during packet encoding", new Object[0]);
                throw new FMLNetworkException(e);
            }
        }
    }
}

