/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import java.util.Collection;
import java.util.Map;

public class ModIdentifiersPacket
extends FMLPacket {
    private Map<String, Integer> modIds = Maps.newHashMap();

    public ModIdentifiersPacket() {
        super(FMLPacket.Type.MOD_IDENTIFIERS);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        Collection<NetworkModHandler> networkMods = FMLNetworkHandler.instance().getNetworkIdMap().values();
        dat.writeInt(networkMods.size());
        for (NetworkModHandler handler : networkMods) {
            dat.writeUTF(handler.getContainer().getModId());
            dat.writeInt(handler.getNetworkId());
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput((byte[])data);
        int listSize = dat.readInt();
        for (int i2 = 0; i2 < listSize; ++i2) {
            String modId = dat.readUTF();
            int networkId = dat.readInt();
            this.modIds.put(modId, networkId);
        }
        return this;
    }

    @Override
    public void execute(az network, FMLNetworkHandler handler, dc netHandler, String userName) {
        for (Map.Entry<String, Integer> idEntry : this.modIds.entrySet()) {
            handler.bindNetworkId(idEntry.getKey(), idEntry.getValue());
        }
    }
}

