/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ModListRequestPacket
extends FMLPacket {
    private List<String> sentModList;

    public ModListRequestPacket() {
        super(FMLPacket.Type.MOD_LIST_REQUEST);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        Set<ModContainer> activeMods = FMLNetworkHandler.instance().getNetworkModList();
        dat.writeInt(activeMods.size());
        for (ModContainer mc : activeMods) {
            dat.writeUTF(mc.getModId());
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        this.sentModList = Lists.newArrayList();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
        int listSize = in.readInt();
        for (int i2 = 0; i2 < listSize; ++i2) {
            this.sentModList.add(in.readUTF());
        }
        return this;
    }

    @Override
    public void execute(az mgr, FMLNetworkHandler handler, dc netHandler, String userName) {
        ArrayList missingMods = Lists.newArrayList();
        HashMap modVersions = Maps.newHashMap();
        HashMap indexedModList = Maps.newHashMap(Loader.instance().getIndexedModList());
        for (String m : this.sentModList) {
            ModContainer mc = (ModContainer)indexedModList.get(m);
            if (mc == null) {
                missingMods.add(m);
                continue;
            }
            indexedModList.remove(m);
            modVersions.put(m, mc.getVersion());
        }
        if (indexedModList.size() > 0) {
            // empty if block
        }
        ce pkt = new ce();
        pkt.a = "FML";
        pkt.c = FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_RESPONSE, modVersions, missingMods);
        pkt.b = pkt.c.length;
        mgr.a((db)pkt);
    }
}

