/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class NetworkRegistry {
    private static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private Multimap<Player, String> activeChannels = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> universalPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> clientPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> serverPacketHandlers = ArrayListMultimap.create();
    private Set<IConnectionHandler> connectionHandlers = Sets.newLinkedHashSet();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();

    public static NetworkRegistry instance() {
        return INSTANCE;
    }

    byte[] getPacketRegistry(Side side) {
        return Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML"), (Iterable)this.universalPacketHandlers.keySet(), (Iterable)(side.isClient() ? this.clientPacketHandlers.keySet() : this.serverPacketHandlers.keySet()))).getBytes(Charsets.UTF_8);
    }

    public boolean isChannelActive(String channel, Player player) {
        return this.activeChannels.containsEntry((Object)player, (Object)channel);
    }

    public void registerChannel(IPacketHandler handler, String channelName) {
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        this.universalPacketHandlers.put((Object)channelName, (Object)handler);
    }

    public void registerChannel(IPacketHandler handler, String channelName, Side side) {
        if (side == null) {
            this.registerChannel(handler, channelName);
            return;
        }
        if (Strings.isNullOrEmpty((String)channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty((String)channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        if (side.isClient()) {
            this.clientPacketHandlers.put((Object)channelName, (Object)handler);
        } else {
            this.serverPacketHandlers.put((Object)channelName, (Object)handler);
        }
    }

    void activateChannel(Player player, String channel) {
        this.activeChannels.put((Object)player, (Object)channel);
    }

    void deactivateChannel(Player player, String channel) {
        this.activeChannels.remove((Object)player, (Object)channel);
    }

    public void registerConnectionHandler(IConnectionHandler handler) {
        this.connectionHandlers.add(handler);
    }

    void playerLoggedIn(gu player, gz netHandler, az manager) {
        this.generateChannelRegistration((og)player, netHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.playerLoggedIn((Player)player, netHandler, manager);
        }
    }

    String connectionReceived(gx netHandler, az manager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            String kick = handler.connectionReceived(netHandler, manager);
            if (Strings.isNullOrEmpty((String)kick)) continue;
            return kick;
        }
        return null;
    }

    void connectionOpened(dc netClientHandler, String server, int port, az networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, port, networkManager);
        }
    }

    void connectionOpened(dc netClientHandler, MinecraftServer server, az networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, networkManager);
        }
    }

    void clientLoggedIn(dc clientHandler, az manager, cs login) {
        this.generateChannelRegistration(clientHandler.getPlayer(), clientHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.clientLoggedIn(clientHandler, manager, login);
        }
    }

    void connectionClosed(az manager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionClosed(manager);
        }
    }

    void generateChannelRegistration(og player, dc netHandler, az manager) {
        ce pkt = new ce();
        pkt.a = "REGISTER";
        pkt.c = this.getPacketRegistry(player instanceof gu ? Side.SERVER : Side.CLIENT);
        pkt.b = pkt.c.length;
        manager.a((db)pkt);
    }

    void handleCustomPacket(ce packet, az network, dc handler) {
        if ("REGISTER".equals(packet.a)) {
            this.handleRegistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else if ("UNREGISTER".equals(packet.a)) {
            this.handleUnregistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else {
            this.handlePacket(packet, network, (Player)((Object)handler.getPlayer()));
        }
    }

    private void handlePacket(ce packet, az network, Player player) {
        String channel = packet.a;
        if (this.activeChannels.containsEntry((Object)player, (Object)channel)) {
            for (IPacketHandler handler : Iterables.concat((Iterable)this.universalPacketHandlers.get((Object)channel), (Iterable)(player instanceof gu ? this.serverPacketHandlers.get((Object)channel) : this.clientPacketHandlers.get((Object)channel)))) {
                handler.onPacketData(network, packet, player);
            }
        }
    }

    private void handleRegistrationPacket(ce packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.activateChannel(player, channel);
        }
    }

    private void handleUnregistrationPacket(ce packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.deactivateChannel(player, channel);
        }
    }

    private List<String> extractChannelList(ce packet) {
        String request = new String(packet.c, Charsets.UTF_8);
        ArrayList channels = Lists.newArrayList((Iterable)Splitter.on((char)'\u0000').split((CharSequence)request));
        return channels;
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc);
        if (nmh == null) {
            FMLLog.log(Level.FINE, "The mod %s needs to be a @NetworkMod to register a Networked Gui Handler", mc.getModId());
        } else {
            this.serverGuiHandlers.put(mc, handler);
        }
        this.clientGuiHandlers.put(mc, handler);
    }

    void openRemoteGui(ModContainer mc, gu player, int modGuiId, up world, int x, int y, int z) {
        ov container;
        IGuiHandler handler = this.serverGuiHandlers.get(mc);
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc);
        if (handler != null && nmh != null && (container = (ov)handler.getServerGuiElement(modGuiId, (og)player, world, x, y, z)) != null) {
            player.bO();
            player.l();
            int windowId = player.cq;
            ce pkt = new ce();
            pkt.a = "FML";
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.GUIOPEN, windowId, nmh.getNetworkId(), modGuiId, x, y, z);
            pkt.b = pkt.c.length;
            player.a.b((db)pkt);
            player.bA = container;
            player.bA.c = windowId;
            player.bA.a((oz)player);
        }
    }

    void openLocalGui(ModContainer mc, og player, int modGuiId, up world, int x, int y, int z) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc);
        FMLCommonHandler.instance().showGuiScreen(handler.getClientGuiElement(modGuiId, player, world, x, y, z));
    }
}

