/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends jn>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(0, 255);
        for (Object id : jr.d.keySet()) {
            this.availableIndicies.clear((Integer)id);
        }
    }

    public static void registerModEntity(Class<? extends jn> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    private void doModEntityRegistration(Class<? extends jn> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            this.entityNames.put(entityName, mc);
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.WARNING, e, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er2);
    }

    public static void registerGlobalEntityID(Class<? extends jn> entityClass, String entityName, int id) {
        EntityRegistry.instance().validateAndClaimId(id);
        jr.a(entityClass, (String)entityName, (int)id);
    }

    private void validateAndClaimId(int id) {
        if (!this.availableIndicies.get(id)) {
            throw new RuntimeException(String.format("Unable to claim entity id %d", id));
        }
        this.availableIndicies.clear(id);
    }

    public static void registerGlobalEntityID(Class<? extends jn> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour) {
        EntityRegistry.instance().validateAndClaimId(id);
        jr.a(entityClass, (String)entityName, (int)id, (int)backgroundEggColour, (int)foregroundEggColour);
    }

    public static void addSpawn(Class<? extends jw> entityClass, int weightedProb, int min, int max, jx typeOfCreature, vk ... biomes) {
        for (vk biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            for (vl entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                break;
            }
            spawns.add(new vl(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, jx spawnList, vk ... biomes) {
        Class entityClazz = (Class)jr.b.get(entityName);
        if (jw.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static void removeSpawn(Class<? extends jw> entityClass, jx typeOfCreature, vk ... biomes) {
        for (vk biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                vl entry = (vl)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, jx spawnList, vk ... biomes) {
        Class entityClazz = (Class)jr.b.get(entityName);
        if (jw.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, spawnList, biomes);
        }
    }

    public static int findGlobalUniqueEntityId() {
        int res = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (res < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return res;
    }

    public EntityRegistration lookupModSpawn(Class<? extends jn> clazz, boolean keepLooking) {
        Class<? extends jn> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(gm entityTracker, jn entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends jn> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;

        public EntityRegistration(ModContainer mc, Class<? extends jn> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends jn> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getModId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }
    }
}

