/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.toposort;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.toposort.TopologicalSort;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ModSorter {
    private TopologicalSort.DirectedGraph<ModContainer> modGraph;
    private ModContainer beforeAll = new DummyModContainer();
    private ModContainer afterAll = new DummyModContainer();
    private ModContainer before = new DummyModContainer();
    private ModContainer after = new DummyModContainer();
    private List<ModContainer> immutableMods;

    public ModSorter(List<ModContainer> modList, Map<String, ModContainer> nameLookup) {
        this.buildGraph(modList, nameLookup);
    }

    private void buildGraph(List<ModContainer> modList, Map<String, ModContainer> nameLookup) {
        this.modGraph = new TopologicalSort.DirectedGraph();
        this.immutableMods = Lists.newArrayList();
        this.modGraph.addNode(this.beforeAll);
        this.modGraph.addNode(this.before);
        this.modGraph.addNode(this.afterAll);
        this.modGraph.addNode(this.after);
        this.modGraph.addEdge(this.before, this.after);
        this.modGraph.addEdge(this.beforeAll, this.before);
        this.modGraph.addEdge(this.after, this.afterAll);
        for (ModContainer mod : modList) {
            if (!mod.isImmutable()) {
                this.modGraph.addNode(mod);
                continue;
            }
            this.immutableMods.add(mod);
        }
        for (ModContainer mod : modList) {
            if (mod.isImmutable()) continue;
            boolean preDepAdded = false;
            boolean postDepAdded = false;
            for (ArtifactVersion dep : mod.getDependencies()) {
                preDepAdded = true;
                if (dep.getLabel().equals("*")) {
                    this.modGraph.addEdge(mod, this.afterAll);
                    this.modGraph.addEdge(this.after, mod);
                    postDepAdded = true;
                    continue;
                }
                this.modGraph.addEdge(this.before, mod);
                if (!nameLookup.containsKey(dep.getLabel())) continue;
                this.modGraph.addEdge(nameLookup.get(dep.getLabel()), mod);
            }
            for (ArtifactVersion dep : mod.getDependants()) {
                postDepAdded = true;
                if (dep.getLabel().equals("*")) {
                    this.modGraph.addEdge(this.beforeAll, mod);
                    this.modGraph.addEdge(mod, this.before);
                    preDepAdded = true;
                    continue;
                }
                this.modGraph.addEdge(mod, this.after);
                if (!nameLookup.containsKey(dep.getLabel())) continue;
                this.modGraph.addEdge(mod, nameLookup.get(dep.getLabel()));
            }
            if (!preDepAdded) {
                this.modGraph.addEdge(this.before, mod);
            }
            if (postDepAdded) continue;
            this.modGraph.addEdge(mod, this.after);
        }
    }

    public List<ModContainer> sort() {
        List<ModContainer> sortedList = TopologicalSort.topologicalSort(this.modGraph);
        sortedList.removeAll(Arrays.asList(this.beforeAll, this.before, this.after, this.afterAll));
        this.immutableMods.addAll(sortedList);
        return this.immutableMods;
    }
}

