/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.ComparableVersion;
import cpw.mods.fml.common.versioning.VersionRange;

public class DefaultArtifactVersion
implements ArtifactVersion {
    private ComparableVersion comparableVersion;
    private String label;
    private boolean unbounded;
    private VersionRange range;

    public DefaultArtifactVersion(String versionNumber) {
        this.comparableVersion = new ComparableVersion(versionNumber);
        this.range = VersionRange.createFromVersion(versionNumber, this);
    }

    public DefaultArtifactVersion(String label, VersionRange range) {
        this.label = label;
        this.range = range;
    }

    public DefaultArtifactVersion(String label, String version) {
        this(version);
        this.label = label;
    }

    public DefaultArtifactVersion(String string, boolean unbounded) {
        this.label = string;
        this.unbounded = true;
    }

    public boolean equals(Object obj) {
        return ((DefaultArtifactVersion)obj).containsVersion(this);
    }

    @Override
    public int compareTo(ArtifactVersion o2) {
        return this.unbounded ? 0 : this.comparableVersion.compareTo(((DefaultArtifactVersion)o2).comparableVersion);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean containsVersion(ArtifactVersion source) {
        if (!source.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (this.unbounded) {
            return true;
        }
        if (this.range != null) {
            return this.range.containsVersion(source);
        }
        return false;
    }

    public String toString() {
        return this.label == null ? this.comparableVersion.toString() : this.label + (this.unbounded ? "" : "@" + this.range);
    }
}

