/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.common.FMLLog;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class Downloader
extends JOptionPane {
    private static Downloader instance;
    private JDialog container;
    private JLabel currentActivity;
    private JProgressBar progress;
    boolean stopIt;
    Thread pokeThread;

    public Downloader() {
        instance = this;
        this.setMessageType(1);
        this.setMessage(this.makeProgressPanel());
        this.setOptions(new Object[]{"Stop"});
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() == instance && evt.getPropertyName() == "value") {
                    Downloader.this.requestClose("This will stop minecraft from launching\nAre you sure you want to do this?");
                }
            }
        });
    }

    private Box makeProgressPanel() {
        Box box = Box.createVerticalBox();
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel welcomeLabel = new JLabel("<html><b><font size='+1'>FML is setting up your minecraft environment</font></b></html>");
        box.add(welcomeLabel);
        welcomeLabel.setAlignmentY(0.0f);
        welcomeLabel = new JLabel("<html>Please wait, FML has some tasks to do before you can play</html>");
        welcomeLabel.setAlignmentY(0.0f);
        box.add(welcomeLabel);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.currentActivity = new JLabel("Currently doing ...");
        box.add(this.currentActivity);
        box.add(Box.createRigidArea(new Dimension(0, 10)));
        this.progress = new JProgressBar(0, 100);
        this.progress.setStringPainted(true);
        box.add(this.progress);
        box.add(Box.createRigidArea(new Dimension(0, 30)));
        return box;
    }

    public static void main(String[] args) {
        instance = new Downloader();
        instance.makeDialog();
    }

    JDialog makeDialog() {
        this.container = new JDialog(null, "Hello", Dialog.ModalityType.MODELESS);
        this.container.setResizable(false);
        this.container.setLocationRelativeTo(null);
        this.container.add(instance);
        instance.updateUI();
        this.container.pack();
        this.container.setMinimumSize(this.container.getPreferredSize());
        this.container.setVisible(true);
        this.container.setDefaultCloseOperation(0);
        this.container.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                instance.requestClose("Closing this window will stop minecraft from launching\nAre you sure you wish to do this?");
            }
        });
        return this.container;
    }

    protected void requestClose(String message) {
        int shouldClose = JOptionPane.showConfirmDialog(this.container, message, "Are you sure you want to stop?", 0, 2);
        if (shouldClose == 0) {
            this.container.dispose();
        }
        this.stopIt = true;
        if (this.pokeThread != null) {
            this.pokeThread.interrupt();
        }
    }

    void updateProgressString(String progressUpdate, Object ... data) {
        FMLLog.finest(progressUpdate, data);
        if (this.currentActivity != null) {
            this.currentActivity.setText(String.format(progressUpdate, data));
        }
    }

    void resetProgress(int sizeGuess) {
        if (this.progress != null) {
            this.progress.getModel().setRangeProperties(0, 0, 0, sizeGuess, false);
        }
    }

    void updateProgress(int fullLength) {
        if (this.progress != null) {
            this.progress.getModel().setValue(fullLength);
        }
    }

    static void makeHeadless() {
        Downloader.instance.container = null;
        Downloader.instance.progress = null;
        Downloader.instance.currentActivity = null;
    }
}

