/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.FMLLogFormatter;
import cpw.mods.fml.relauncher.FMLRelauncher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FMLRelaunchLog {
    public static FMLRelaunchLog log = new FMLRelaunchLog();
    static File minecraftHome;
    private static boolean configured;
    private Logger myLog;

    private FMLRelaunchLog() {
    }

    private static void configureLogging() {
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
        FMLRelaunchLog.log.myLog = Logger.getLogger("ForgeModLoader");
        Logger stdOut = Logger.getLogger("STDOUT");
        stdOut.setParent(FMLRelaunchLog.log.myLog);
        Logger stdErr = Logger.getLogger("STDERR");
        stdErr.setParent(FMLRelaunchLog.log.myLog);
        FMLLogFormatter formatter = new FMLLogFormatter();
        ConsoleHandler ch2 = new ConsoleHandler();
        ch2.setLevel(Level.parse(System.getProperty("fml.log.level", "INFO")));
        FMLRelaunchLog.log.myLog.setUseParentHandlers(false);
        FMLRelaunchLog.log.myLog.addHandler(ch2);
        ch2.setFormatter(formatter);
        FMLRelaunchLog.log.myLog.setLevel(Level.ALL);
        try {
            File logPath = new File(minecraftHome, FMLRelauncher.logFileNamePattern);
            FileHandler fileHandler = new FileHandler(logPath.getPath(), 0, 3);
            fileHandler.setFormatter(formatter);
            fileHandler.setLevel(Level.ALL);
            FMLRelaunchLog.log.myLog.addHandler(fileHandler);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.setOut(new PrintStream(new LoggingOutStream(stdOut), true));
        System.setErr(new PrintStream(new LoggingOutStream(stdErr), true));
        configured = true;
    }

    public static void log(Level level, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data));
    }

    public static void log(Level level, Throwable ex, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data), ex);
    }

    public static void severe(String format, Object ... data) {
        FMLRelaunchLog.log(Level.SEVERE, format, data);
    }

    public static void warning(String format, Object ... data) {
        FMLRelaunchLog.log(Level.WARNING, format, data);
    }

    public static void info(String format, Object ... data) {
        FMLRelaunchLog.log(Level.INFO, format, data);
    }

    public static void fine(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINE, format, data);
    }

    public static void finer(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINER, format, data);
    }

    public static void finest(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINEST, format, data);
    }

    public Logger getLogger() {
        return this.myLog;
    }

    private static class LoggingOutStream
    extends ByteArrayOutputStream {
        private Logger log;
        private StringBuilder currentMessage;

        public LoggingOutStream(Logger log) {
            this.log = log;
            this.currentMessage = new StringBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            LoggingOutStream loggingOutStream = this;
            synchronized (loggingOutStream) {
                super.flush();
                String record = this.toString();
                super.reset();
                this.currentMessage.append(record);
                if (this.currentMessage.lastIndexOf(FMLLogFormatter.LINE_SEPARATOR) >= 0) {
                    if (this.currentMessage.length() > FMLLogFormatter.LINE_SEPARATOR.length()) {
                        this.currentMessage.setLength(this.currentMessage.length() - FMLLogFormatter.LINE_SEPARATOR.length());
                        this.log.log(Level.INFO, this.currentMessage.toString());
                    }
                    this.currentMessage.setLength(0);
                }
            }
        }
    }
}

