/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class RelaunchClassLoader
extends URLClassLoader {
    private static String[] excludedPackages = new String[]{"java.", "sun.", "javax.", "cpw.mods.fml.relauncher.", "net.minecraftforge.classloading."};
    private static String[] transformerExclusions = new String[]{"org.objectweb.asm.", "com.google.common.", "cpw.mods.fml."};
    private List<URL> sources;
    private ClassLoader parent;
    private List<IClassTransformer> transformers;
    private Map<String, Class> cachedClasses;

    public RelaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.parent = this.getClass().getClassLoader();
        this.cachedClasses = new HashMap<String, Class>(1000);
        this.transformers = new ArrayList<IClassTransformer>(2);
        Thread.currentThread().setContextClassLoader(this);
    }

    public void registerTransformer(String transformerClassName) {
        try {
            this.transformers.add((IClassTransformer)this.loadClass(transformerClassName).newInstance());
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.SEVERE, e, "A critical problem occured registering the ASM transformer class %s", transformerClassName);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (String st : excludedPackages) {
            if (!name.startsWith(st)) continue;
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        for (String st : transformerExclusions) {
            if (!name.startsWith(st)) continue;
            Class<?> cl2 = super.findClass(name);
            this.cachedClasses.put(name, cl2);
            return cl2;
        }
        try {
            String pkgname;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > -1 && this.getPackage(pkgname = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            byte[] basicClass = this.getClassBytes(name);
            byte[] transformedClass = this.runTransformers(name, basicClass);
            Class<?> cl3 = this.defineClass(name, transformedClass, 0, transformedClass.length);
            this.cachedClasses.put(name, cl3);
            return cl3;
        }
        catch (Throwable e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        InputStream classStream = null;
        try {
            URL classResource = this.findResource(name.replace('.', '/').concat(".class"));
            if (classResource == null) {
                byte[] byArray = null;
                return byArray;
            }
            classStream = classResource.openStream();
            byte[] byArray = this.readFully(classStream);
            return byArray;
        }
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private byte[] runTransformers(String name, byte[] basicClass) {
        for (IClassTransformer transformer : this.transformers) {
            basicClass = transformer.transform(name, basicClass);
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            int r2;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(stream.available());
            while ((r2 = stream.read()) != -1) {
                bos.write(r2);
            }
            return bos.toByteArray();
        }
        catch (Throwable t) {
            return new byte[0];
        }
    }
}

