/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.Property;

public class Configuration {
    private boolean[] configBlocks = null;
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_ITEM = "item";
    File file;
    public Map<String, Map<String, Property>> categories = new TreeMap<String, Map<String, Property>>();
    public TreeMap<String, Property> blockProperties = new TreeMap();
    public TreeMap<String, Property> itemProperties = new TreeMap();
    public TreeMap<String, Property> generalProperties = new TreeMap();
    public static final String ALLOWED_CHARS = "._-";

    public Configuration(File file) {
        this.file = file;
        this.categories.put(CATEGORY_GENERAL, this.generalProperties);
        this.categories.put(CATEGORY_BLOCK, this.blockProperties);
        this.categories.put(CATEGORY_ITEM, this.itemProperties);
    }

    public Property getOrCreateBlockIdProperty(String key, int defaultId) {
        Map<String, Property> properties;
        if (this.configBlocks == null) {
            this.configBlocks = new boolean[aig.m.length];
            for (int i = 0; i < this.configBlocks.length; ++i) {
                this.configBlocks[i] = false;
            }
        }
        if ((properties = this.categories.get(CATEGORY_BLOCK)).containsKey(key)) {
            Property property = this.getOrCreateIntProperty(key, CATEGORY_BLOCK, defaultId);
            this.configBlocks[Integer.parseInt((String)property.value)] = true;
            return property;
        }
        Property property = new Property();
        properties.put(key, property);
        property.setName(key);
        if (aig.m[defaultId] == null && !this.configBlocks[defaultId]) {
            property.value = Integer.toString(defaultId);
            this.configBlocks[defaultId] = true;
            return property;
        }
        for (int j2 = this.configBlocks.length - 1; j2 >= 0; --j2) {
            if (aig.m[j2] != null || this.configBlocks[j2]) continue;
            property.value = Integer.toString(j2);
            this.configBlocks[j2] = true;
            return property;
        }
        throw new RuntimeException("No more block ids available for " + key);
    }

    public Property getOrCreateIntProperty(String key, String category, int defaultValue) {
        Property prop = this.getOrCreateProperty(key, category, Integer.toString(defaultValue));
        try {
            Integer.parseInt(prop.value);
            return prop;
        }
        catch (NumberFormatException e) {
            prop.value = Integer.toString(defaultValue);
            return prop;
        }
    }

    public Property getOrCreateBooleanProperty(String key, String category, boolean defaultValue) {
        Property prop = this.getOrCreateProperty(key, category, Boolean.toString(defaultValue));
        if ("true".equals(prop.value.toLowerCase(Locale.ENGLISH)) || "false".equals(prop.value.toLowerCase(Locale.ENGLISH))) {
            return prop;
        }
        prop.value = Boolean.toString(defaultValue);
        return prop;
    }

    public Property getOrCreateProperty(String key, String category, String defaultValue) {
        Map<String, Property> source = this.categories.get(category = category.toLowerCase(Locale.ENGLISH));
        if (source == null) {
            source = new TreeMap<String, Property>();
            this.categories.put(category, source);
        }
        if (source.containsKey(key)) {
            return source.get(key);
        }
        if (defaultValue != null) {
            Property property = new Property();
            source.put(key, property);
            property.setName(key);
            property.value = defaultValue;
            return property;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block31: {
            BufferedReader buffer = null;
            try {
                String line;
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                if (!this.file.exists() && !this.file.createNewFile()) {
                    return;
                }
                if (!this.file.canRead()) break block31;
                FileInputStream fileinputstream = new FileInputStream(this.file);
                buffer = new BufferedReader(new InputStreamReader((InputStream)fileinputstream, "8859_1"));
                Map<String, Property> currentMap = null;
                block20: while ((line = buffer.readLine()) != null) {
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    int i = 0;
                    while (true) {
                        if (i >= line.length() || skip) continue block20;
                        if (Character.isLetterOrDigit(line.charAt(i)) || ALLOWED_CHARS.indexOf(line.charAt(i)) != -1) {
                            if (nameStart == -1) {
                                nameStart = i;
                            }
                            nameEnd = i;
                        } else if (!Character.isWhitespace(line.charAt(i))) {
                            switch (line.charAt(i)) {
                                case '#': {
                                    skip = true;
                                    break;
                                }
                                case '{': {
                                    String scopeName = line.substring(nameStart, nameEnd + 1);
                                    currentMap = this.categories.get(scopeName);
                                    if (currentMap != null) break;
                                    currentMap = new TreeMap<String, Property>();
                                    this.categories.put(scopeName, currentMap);
                                    break;
                                }
                                case '}': {
                                    currentMap = null;
                                    break;
                                }
                                case '=': {
                                    String propertyName = line.substring(nameStart, nameEnd + 1);
                                    if (currentMap == null) {
                                        throw new RuntimeException("property " + propertyName + " has no scope");
                                    }
                                    Property prop = new Property();
                                    prop.setName(propertyName);
                                    prop.value = line.substring(i + 1);
                                    i = line.length();
                                    currentMap.put(propertyName, prop);
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("unknown character " + line.charAt(i));
                                }
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void save() {
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "8859_1"));
                buffer.write("# Configuration file\r\n");
                buffer.write("# Generated on " + DateFormat.getInstance().format(new Date()) + "\r\n");
                buffer.write("\r\n");
                for (Map.Entry<String, Map<String, Property>> category : this.categories.entrySet()) {
                    buffer.write("####################\r\n");
                    buffer.write("# " + category.getKey() + " \r\n");
                    buffer.write("####################\r\n\r\n");
                    buffer.write(category.getKey() + " {\r\n");
                    this.writeProperties(buffer, category.getValue().values());
                    buffer.write("}\r\n\r\n");
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeProperties(BufferedWriter buffer, Collection<Property> props) throws IOException {
        for (Property property : props) {
            if (property.comment != null) {
                buffer.write("   # " + property.comment + "\r\n");
            }
            buffer.write("   " + property.getName() + "=" + property.value);
            buffer.write("\r\n");
        }
    }
}

