/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends xc>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, gr> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();

    public static boolean registerProviderType(int id, Class<? extends xc> provider, boolean keepLoaded) {
        if (providers.containsValue(id)) {
            return false;
        }
        providers.put(id, provider);
        spawnSettings.put(id, keepLoaded);
        return true;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        DimensionManager.registerProviderType(0, xe.class, true);
        DimensionManager.registerProviderType(-1, xd.class, true);
        DimensionManager.registerProviderType(1, xf.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimensiuon for id %d, provider type %d does not exist", id, providerType));
        }
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimensiuon for id %d, One is already registered", id));
        }
        dimensions.put(id, providerType);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static xc getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).w;
    }

    public static Integer[] getIDs() {
        return dimensions.keySet().toArray(new Integer[0]);
    }

    public static void setWorld(int id, gr world) {
        worlds.put(id, world);
        ArrayList<gr> tmp = new ArrayList<gr>();
        tmp.add(worlds.get(0));
        tmp.add(worlds.get(-1));
        tmp.add(worlds.get(1));
        for (Map.Entry<Integer, gr> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.C().c = tmp.toArray(new gr[0]);
        MinecraftServer.C().worldTickTimes.put(id, new long[100]);
    }

    public static gr getWorld(int id) {
        return worlds.get(id);
    }

    public static gr[] getWorlds() {
        return worlds.values().toArray(new gr[0]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id = DimensionManager.getProviderType(dim);
        return spawnSettings.contains(id) && spawnSettings.get(id) != false;
    }

    public static xc createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                xc provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            return null;
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), e);
            throw new RuntimeException(e);
        }
    }

    static {
        DimensionManager.init();
    }
}

