/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Random;

public class DungeonHooks {
    private static int dungeonLootAttempts = 8;
    private static ArrayList<DungeonMob> dungeonMobs = new ArrayList();
    private static ArrayList<DungeonLoot> dungeonLoot = new ArrayList();

    public static void setDungeonLootTries(int number) {
        dungeonLootAttempts = number;
    }

    public static int getDungeonLootTries() {
        return dungeonLootAttempts;
    }

    public static float addDungeonMob(String name, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            return mob.a += rarity;
        }
        dungeonMobs.add(new DungeonMob(rarity, name));
        return rarity;
    }

    public static int removeDungeonMob(String name) {
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            dungeonMobs.remove((Object)mob);
            return mob.a;
        }
        return 0;
    }

    public static String getRandomDungeonMob(Random rand) {
        DungeonMob mob = (DungeonMob)ir.a((Random)rand, dungeonMobs);
        if (mob == null) {
            return "";
        }
        return mob.type;
    }

    public static void addDungeonLoot(rj item, int rarity) {
        DungeonHooks.addDungeonLoot(item, rarity, 1, 1);
    }

    public static float addDungeonLoot(rj item, int rarity, int minCount, int maxCount) {
        for (DungeonLoot loot : dungeonLoot) {
            if (!loot.equals(item, minCount, maxCount)) continue;
            return loot.a += rarity;
        }
        dungeonLoot.add(new DungeonLoot(rarity, item, minCount, maxCount));
        return rarity;
    }

    public static void removeDungeonLoot(rj item) {
        DungeonHooks.removeDungeonLoot(item, -1, 0);
    }

    public static void removeDungeonLoot(rj item, int minCount, int maxCount) {
        ArrayList lootTmp = (ArrayList)dungeonLoot.clone();
        if (minCount < 0) {
            for (DungeonLoot loot : lootTmp) {
                if (!loot.equals(item)) continue;
                dungeonLoot.remove((Object)loot);
            }
        } else {
            for (DungeonLoot loot : lootTmp) {
                if (!loot.equals(item, minCount, maxCount)) continue;
                dungeonLoot.remove((Object)loot);
            }
        }
    }

    public static rj getRandomDungeonLoot(Random rand) {
        DungeonLoot ret = (DungeonLoot)ir.a((Random)rand, dungeonLoot);
        if (ret != null) {
            return ret.generateStack(rand);
        }
        return null;
    }

    static {
        DungeonHooks.addDungeonMob("Skeleton", 100);
        DungeonHooks.addDungeonMob("Zombie", 200);
        DungeonHooks.addDungeonMob("Spider", 100);
        DungeonHooks.addDungeonLoot(new rj(rh.aA), 100);
        DungeonHooks.addDungeonLoot(new rj(rh.o), 100, 1, 4);
        DungeonHooks.addDungeonLoot(new rj(rh.U), 100);
        DungeonHooks.addDungeonLoot(new rj(rh.T), 100, 1, 4);
        DungeonHooks.addDungeonLoot(new rj(rh.M), 100, 1, 4);
        DungeonHooks.addDungeonLoot(new rj(rh.K), 100, 1, 4);
        DungeonHooks.addDungeonLoot(new rj(rh.aw), 100);
        DungeonHooks.addDungeonLoot(new rj(rh.at), 1);
        DungeonHooks.addDungeonLoot(new rj(rh.aC), 40, 1, 4);
        DungeonHooks.addDungeonLoot(new rj(rh.bI), 5);
        DungeonHooks.addDungeonLoot(new rj(rh.bJ), 5);
        DungeonHooks.addDungeonLoot(new rj(rh.aW, 1, 3), 100);
    }

    public static class DungeonMob
    extends is {
        public String type;

        public DungeonMob(int weight, String type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            if (target instanceof DungeonMob) {
                return this.type.equals(((DungeonMob)((Object)target)).type);
            }
            return false;
        }
    }

    public static class DungeonLoot
    extends is {
        private rj itemStack;
        private int minCount = 1;
        private int maxCount = 1;

        public DungeonLoot(int weight, rj item, int min, int max) {
            super(weight);
            this.itemStack = item;
            this.minCount = min;
            this.maxCount = max;
        }

        public rj generateStack(Random rand) {
            rj ret = this.itemStack.l();
            ret.a = this.minCount + rand.nextInt(this.maxCount - this.minCount + 1);
            return ret;
        }

        public boolean equals(rj item, int min, int max) {
            return min == this.minCount && max == this.maxCount && item.a(this.itemStack);
        }

        public boolean equals(rj item) {
            return item.a(this.itemStack);
        }
    }
}

