/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class[][] commonTypes = new Class[][]{{sl.class}, {pu.class, Integer.TYPE, int[].class, Integer.TYPE}, {ka.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {jy.class}, {jx.class, Class.class, Integer.TYPE, aco.class, Boolean.TYPE}, {abd.class}, {tt.class}, {jp.class}, {ahf.class}, {ajr.class}, {vb.class, Integer.TYPE}, {oh.class}, {ri.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE}};

    public static sl addAction(String name) {
        return EnumHelper.addEnum(sl.class, name, new Object[0]);
    }

    public static pu addArmorMaterial(String name, int durability, int[] reductionAmounts, int enchantability) {
        return EnumHelper.addEnum(pu.class, name, durability, reductionAmounts, enchantability);
    }

    public static ka addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(ka.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    public static jy addCreatureAttribute(String name) {
        return EnumHelper.addEnum(jy.class, name, new Object[0]);
    }

    public static jx addCreatureType(String name, Class typeClass, int maxNumber, aco material, boolean peaceful) {
        return EnumHelper.addEnum(jx.class, name, typeClass, maxNumber, material, peaceful);
    }

    public static abd addDoor(String name) {
        return EnumHelper.addEnum(abd.class, name, new Object[0]);
    }

    public static tt addEnchantmentType(String name) {
        return EnumHelper.addEnum(tt.class, name, new Object[0]);
    }

    public static jp addEntitySize(String name) {
        return EnumHelper.addEnum(jp.class, name, new Object[0]);
    }

    public static ahf addMobType(String name) {
        return EnumHelper.addEnum(ahf.class, name, new Object[0]);
    }

    public static ajr addMovingObjectType(String name) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        return EnumHelper.addEnum(ajr.class, name, new Object[0]);
    }

    public static vb addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(vb.class, name, lightValue);
    }

    public static oh addStatus(String name) {
        return EnumHelper.addEnum(oh.class, name, new Object[0]);
    }

    public static ri addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, int damage, int enchantability) {
        return EnumHelper.addEnum(ri.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), damage, enchantability);
    }

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{parms})));
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        Field[] fields = enumType.getDeclaredFields();
        int flags = 4122;
        String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
        for (Field field : fields) {
            if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
            valuesField = field;
            break;
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = EnumHelper.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

