/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<rh, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(up world, int x, int y, int z) {
        GrassEntry grass = (GrassEntry)ir.a((Random)world.v, grassList);
        if (grass == null || grass.block == null || !grass.block.d(world, x, y, z)) {
            return;
        }
        world.d(x, y, z, grass.block.ca, grass.metadata);
    }

    public static rj getGrassSeed(up world) {
        SeedEntry entry = (SeedEntry)ir.a((Random)world.v, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.l();
    }

    public static boolean canHarvestBlock(aig block, og player, int metadata) {
        if (block.cp.l()) {
            return true;
        }
        rj stack = player.by.g();
        if (stack == null) {
            return player.b(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.b(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.b(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(aig block, og player, up world, int x, int y, int z) {
        int metadata = world.g(x, y, z);
        float hardness = block.m(world, x, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            return 1.0f / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(rj stack, aig block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        if (toolClass == null) {
            return false;
        }
        return toolEffectiveness.contains(Arrays.asList(block, metadata, (String)toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(rh.t, "pickaxe", 0);
        MinecraftForge.setToolClass(rh.x, "pickaxe", 1);
        MinecraftForge.setToolClass(rh.g, "pickaxe", 2);
        MinecraftForge.setToolClass(rh.I, "pickaxe", 0);
        MinecraftForge.setToolClass(rh.B, "pickaxe", 3);
        MinecraftForge.setToolClass(rh.u, "axe", 0);
        MinecraftForge.setToolClass(rh.y, "axe", 1);
        MinecraftForge.setToolClass(rh.h, "axe", 2);
        MinecraftForge.setToolClass(rh.J, "axe", 0);
        MinecraftForge.setToolClass(rh.C, "axe", 3);
        MinecraftForge.setToolClass(rh.s, "shovel", 0);
        MinecraftForge.setToolClass(rh.w, "shovel", 1);
        MinecraftForge.setToolClass(rh.f, "shovel", 2);
        MinecraftForge.setToolClass(rh.H, "shovel", 0);
        MinecraftForge.setToolClass(rh.A, "shovel", 3);
        for (aig block : rq.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (aig block : sb.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (aig block : rf.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(aig.ap, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(aig.bR, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.aw, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.ax, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.G, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.ah, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.H, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aig.ai, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aig.N, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aig.O, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(aig.aN, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(aig.aO, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(aig.aN, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aig.ap, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(aig.aO, "pickaxe");
    }

    public static String getTexture(String _default, Object obj) {
        if (obj instanceof rh) {
            return ((rh)obj).getTextureFile();
        }
        if (obj instanceof aig) {
            return ((aig)obj).getTextureFile();
        }
        return _default;
    }

    public static int getTotalArmorValue(og player) {
        int ret = 0;
        for (int x = 0; x < player.by.b.length; ++x) {
            rj stack = player.by.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.b())).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof pt)) continue;
            ret += ((pt)stack.b()).b;
        }
        return ret;
    }

    public static boolean onPickBlock(ajq target, og player, up world) {
        int x;
        rj result = null;
        boolean isCreative = player.bZ.d;
        if (target.a == ajr.a) {
            x = target.b;
            int y = target.c;
            int z = target.d;
            aig var8 = aig.m[world.a(x, y, z)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x, y, z);
        } else {
            if (target.a != ajr.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x = 0; x < 9; ++x) {
            rj stack = player.by.a(x);
            if (stack == null || !stack.a(result)) continue;
            player.by.c = x;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.by.i();
        if (slot < 0 || slot >= 9) {
            return false;
        }
        player.by.a(slot, result);
        player.by.c = slot;
        return true;
    }

    static {
        grassList.add(new GrassEntry((aig)aig.ad, 0, 20));
        grassList.add(new GrassEntry((aig)aig.ae, 0, 10));
        seedList.add(new SeedEntry(new rj(rh.S), 10));
        ForgeHooks.initTools();
        System.out.printf("MinecraftForge v%s Initialized\n", ForgeVersion.getVersion());
        ModLoader.getLogger().info(String.format("MinecraftForge v%s Initialized", ForgeVersion.getVersion()));
    }

    static class SeedEntry
    extends is {
        public final rj seed;

        public SeedEntry(rj seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends is {
        public final aig block;
        public final int metadata;

        public GrassEntry(aig block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

