/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinecartRegistry {
    private static Map<MinecartKey, rj> itemForMinecart = new HashMap<MinecartKey, rj>();
    private static Map<rj, MinecartKey> minecartForItem = new HashMap<rj, MinecartKey>();

    public static void registerMinecart(Class<? extends nk> cart, rj item) {
        MinecartRegistry.registerMinecart(cart, 0, item);
    }

    public static void registerMinecart(Class<? extends nk> minecart, int type, rj item) {
        MinecartKey key = new MinecartKey(minecart, type);
        itemForMinecart.put(key, item);
        minecartForItem.put(item, key);
    }

    public static void removeMinecart(Class<? extends nk> minecart, int type) {
        MinecartKey key = new MinecartKey(minecart, type);
        rj item = itemForMinecart.remove(key);
        if (item != null) {
            minecartForItem.remove(item);
        }
    }

    public static rj getItemForCart(Class<? extends nk> minecart) {
        return MinecartRegistry.getItemForCart(minecart, 0);
    }

    public static rj getItemForCart(Class<? extends nk> minecart, int type) {
        rj item = itemForMinecart.get(new MinecartKey(minecart, type));
        if (item == null) {
            return null;
        }
        return item.l();
    }

    public static rj getItemForCart(nk cart) {
        return MinecartRegistry.getItemForCart(cart.getClass(), cart.getMinecartType());
    }

    public static Class<? extends nk> getCartClassForItem(rj item) {
        MinecartKey key = null;
        for (Map.Entry<rj, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.minecart;
        }
        return null;
    }

    public static int getCartTypeForItem(rj item) {
        MinecartKey key = null;
        for (Map.Entry<rj, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.type;
        }
        return -1;
    }

    public static Set<rj> getAllCartItems() {
        HashSet<rj> ret = new HashSet<rj>();
        for (rj item : minecartForItem.keySet()) {
            ret.add(item.l());
        }
        return ret;
    }

    static {
        MinecartRegistry.registerMinecart(nk.class, 0, new rj(rh.az));
        MinecartRegistry.registerMinecart(nk.class, 1, new rj(rh.aN));
        MinecartRegistry.registerMinecart(nk.class, 2, new rj(rh.aO));
    }

    public static class MinecartKey {
        public final Class<? extends nk> minecart;
        public final int type;

        public MinecartKey(Class<? extends nk> cls, int typtID) {
            this.minecart = cls;
            this.type = typtID;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MinecartKey other = (MinecartKey)obj;
            if (!(this.minecart == other.minecart || this.minecart != null && this.minecart.equals(other.minecart))) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.minecart != null ? this.minecart.hashCode() : 0);
            hash = 59 * hash + this.type;
            return hash;
        }
    }
}

