/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.EventBus;

public class MinecraftForge {
    public static final EventBus EVENT_BUS = new EventBus();
    public static boolean SPAWNER_ALLOW_ON_INVERTED = false;

    public static void addGrassPlant(aig block, int metadata, int weight) {
        ForgeHooks.grassList.add(new ForgeHooks.GrassEntry(block, metadata, weight));
    }

    public static void addGrassSeed(rj seed, int weight) {
        ForgeHooks.seedList.add(new ForgeHooks.SeedEntry(seed, weight));
    }

    public static void setToolClass(rh tool, String toolClass, int harvestLevel) {
        ForgeHooks.toolClasses.put(tool, Arrays.asList(toolClass, harvestLevel));
    }

    public static void setBlockHarvestLevel(aig block, int metadata, String toolClass, int harvestLevel) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
        ForgeHooks.toolEffectiveness.add(key);
    }

    public static void removeBlockEffectiveness(aig block, int metadata, String toolClass) {
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        ForgeHooks.toolEffectiveness.remove(key);
    }

    public static void setBlockHarvestLevel(aig block, String toolClass, int harvestLevel) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolHarvestLevels.put(key, harvestLevel);
            ForgeHooks.toolEffectiveness.add(key);
        }
    }

    public static int getBlockHarvestLevel(aig block, int metadata, String toolClass) {
        ForgeHooks.initTools();
        List<Object> key = Arrays.asList(block, metadata, toolClass);
        Integer harvestLevel = ForgeHooks.toolHarvestLevels.get(key);
        if (harvestLevel == null) {
            return -1;
        }
        return harvestLevel;
    }

    public static void removeBlockEffectiveness(aig block, String toolClass) {
        for (int metadata = 0; metadata < 16; ++metadata) {
            List<Object> key = Arrays.asList(block, metadata, toolClass);
            ForgeHooks.toolEffectiveness.remove(key);
        }
    }

    public static void initialize() {
        aig filler = new aig(0, aco.a);
        aig.m[0] = null;
        aig.n[0] = false;
        aig.o[0] = 0;
        aig.p[0] = false;
        for (int x = 256; x < 4096; ++x) {
            if (rh.e[x] == null) continue;
            aig.m[x] = filler;
        }
        boolean[] temp = new boolean[4096];
        for (int x = 0; x < np.d.length; ++x) {
            temp[x] = np.d[x];
        }
        np.d = temp;
    }

    public static String getBrandingVersion() {
        return "Minecraft Forge " + ForgeVersion.getVersion();
    }
}

