/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

public class Property {
    private String name;
    public String value;
    public String comment;

    public int getInt() {
        return this.getInt(-1);
    }

    public int getInt(int _default) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public boolean isIntValue() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getBoolean(boolean _default) {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return _default;
    }

    public boolean isBooleanValue() {
        return "true".equals(this.value.toLowerCase()) || "false".equals(this.value.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        for (char c : name.toCharArray()) {
            if (Character.isLetterOrDigit(c) || "._-".indexOf(c) != -1 || Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("Invalid property name: \"" + name + "\"");
        }
        this.name = name;
    }
}

