/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class OreDictionary {
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<rj>> oreStacks = new HashMap();

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static ArrayList<rj> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[0]);
    }

    public static ArrayList<rj> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    public static void registerOre(String name, rh ore) {
        OreDictionary.registerOre(name, new rj(ore));
    }

    public static void registerOre(String name, aig ore) {
        OreDictionary.registerOre(name, new rj(ore));
    }

    public static void registerOre(String name, rj ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, rh ore) {
        OreDictionary.registerOre(id, new rj(ore));
    }

    public static void registerOre(int id, aig ore) {
        OreDictionary.registerOre(id, new rj(ore));
    }

    public static void registerOre(int id, rj ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, rj ore) {
        ArrayList<rj> ores = OreDictionary.getOres(id);
        ore = ore.l();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final rj Ore;

        public OreRegisterEvent(String name, rj ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

