/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.transformers;

import cpw.mods.fml.relauncher.IClassTransformer;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ListenerList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventTransformer
implements IClassTransformer {
    @Override
    public byte[] transform(String name, byte[] bytes) {
        if (name.equals("net.minecraftforge.event.Event") || name.startsWith("net.minecraft.src.") || name.indexOf(46) == -1) {
            return bytes;
        }
        ClassReader cr2 = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr2.accept((ClassVisitor)classNode, 0);
        try {
            if (this.buildEvents(classNode)) {
                ClassWriter cw = new ClassWriter(3);
                classNode.accept((ClassVisitor)cw);
                return cw.toByteArray();
            }
            return bytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bytes;
        }
    }

    private boolean buildEvents(ClassNode classNode) throws Exception {
        MethodNode method2;
        Class<?> parent = this.getClass().getClassLoader().loadClass(classNode.superName.replace('/', '.'));
        if (!Event.class.isAssignableFrom(parent)) {
            return false;
        }
        boolean hasSetup = false;
        boolean hasGetListenerList = false;
        boolean hasDefaultCtr = false;
        Type tList = Type.getType(ListenerList.class);
        for (MethodNode method2 : classNode.methods) {
            if (method2.name.equals("setup") && method2.desc.equals(Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])) && (method2.access & 4) == 4) {
                hasSetup = true;
            }
            if (method2.name.equals("getListenerList") && method2.desc.equals(Type.getMethodDescriptor((Type)tList, (Type[])new Type[0])) && (method2.access & 1) == 1) {
                hasGetListenerList = true;
            }
            if (!method2.name.equals("<init>") || !method2.desc.equals(Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]))) continue;
            hasDefaultCtr = true;
        }
        if (hasSetup) {
            if (!hasGetListenerList) {
                throw new RuntimeException("Event class defines setup() but does not define getListenerList! " + classNode.name);
            }
            return false;
        }
        Type tSuper = Type.getType((String)classNode.superName);
        classNode.fields.add(new FieldNode(10, "LISTENER_LIST", tList.getDescriptor(), null, null));
        method2 = new MethodNode(262144, 1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        if (!hasDefaultCtr) {
            classNode.methods.add(method2);
        }
        method2 = new MethodNode(262144, 4, "setup", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "setup", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", tList.getDescriptor()));
        LabelNode initLisitener = new LabelNode();
        method2.instructions.add((AbstractInsnNode)new JumpInsnNode(198, initLisitener));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        method2.instructions.add((AbstractInsnNode)initLisitener);
        method2.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        method2.instructions.add((AbstractInsnNode)new TypeInsnNode(187, tList.getInternalName()));
        method2.instructions.add((AbstractInsnNode)new InsnNode(89));
        method2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tSuper.getInternalName(), "getListenerList", Type.getMethodDescriptor((Type)tList, (Type[])new Type[0])));
        method2.instructions.add((AbstractInsnNode)new MethodInsnNode(183, tList.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{tList})));
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, "LISTENER_LIST", tList.getDescriptor()));
        method2.instructions.add((AbstractInsnNode)new InsnNode(177));
        classNode.methods.add(method2);
        method2 = new MethodNode(262144, 1, "getListenerList", Type.getMethodDescriptor((Type)tList, (Type[])new Type[0]), null, null);
        method2.instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, "LISTENER_LIST", tList.getDescriptor()));
        method2.instructions.add((AbstractInsnNode)new InsnNode(176));
        classNode.methods.add(method2);
        return true;
    }
}

