/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.client.GuiCustomModLoadingErrorScreen;
import cpw.mods.fml.client.GuiModsMissing;
import cpw.mods.fml.client.GuiModsMissingForServer;
import cpw.mods.fml.client.GuiWrongMinecraft;
import cpw.mods.fml.client.TextureFXManager;
import cpw.mods.fml.client.modloader.ModLoaderClientHelper;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.network.EntitySpawnAdjustmentPacket;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import cpw.mods.fml.common.network.ModMissingPacket;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private Minecraft client;
    private DummyModContainer optifineContainer;
    private boolean guiLoaded;
    private boolean serverIsRunning;
    private MissingModsException modsMissing;
    private boolean loading;
    private WrongMinecraftVersionException wrongMC;
    private CustomModLoadingErrorDisplayException customError;

    public void beginMinecraftLoading(Minecraft minecraft) {
        if (minecraft.q()) {
            FMLLog.severe("DEMO MODE DETECTED, FML will not work. Finishing now.", new Object[0]);
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        this.loading = true;
        this.client = minecraft;
        ObfuscationReflectionHelper.detectObfuscation(xd.class);
        TextureFXManager.instance().setClient(this.client);
        FMLCommonHandler.instance().beginLoading(this);
        new ModLoaderClientHelper(this.client);
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            ModMetadata optifineMetadata = MetadataCollection.from(this.getClass().getResourceAsStream("optifinemod.info"), "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
            this.optifineContainer = new DummyModContainer(optifineMetadata);
            FMLLog.info("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion());
        }
        catch (Exception e2) {
            this.optifineContainer = null;
        }
        try {
            Loader.instance().loadMods();
        }
        catch (WrongMinecraftVersionException wrong) {
            this.wrongMC = wrong;
        }
        catch (MissingModsException missing) {
            this.modsMissing = missing;
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        this.client.c(new a(message, t));
        throw Throwables.propagate((Throwable)t);
    }

    public void finishMinecraftLoading() {
        if (this.modsMissing != null || this.wrongMC != null) {
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (CustomModLoadingErrorDisplayException custom) {
            FMLLog.log(Level.SEVERE, custom, "A custom exception was thrown by a mod, the game will now halt", new Object[0]);
            this.customError = custom;
            return;
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
        LanguageRegistry.reloadLanguageTable();
        RenderingRegistry.instance().loadEntityRenderers(azv.a.o);
        this.loading = false;
        KeyBindingRegistry.instance().uploadKeyBindingsToGame(this.client.y);
    }

    public void onInitializationComplete() {
        if (this.wrongMC != null) {
            this.client.a(new GuiWrongMinecraft(this.wrongMC));
        } else if (this.modsMissing != null) {
            this.client.a(new GuiModsMissing(this.modsMissing));
        } else if (this.customError != null) {
            this.client.a(new GuiCustomModLoadingErrorScreen(this.customError));
        } else {
            TextureFXManager.instance().loadTextures(this.client.C.e());
        }
    }

    public Minecraft getClient() {
        return this.client;
    }

    public Logger getMinecraftLogger() {
        return null;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(qf player, asv gui) {
        if (this.client.g == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return Collections.emptyList();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(Object clientGuiElement) {
        asv gui = (asv)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public la spawnEntityIntoClientWorld(EntityRegistry.EntityRegistration er2, EntitySpawnPacket packet) {
        awy wc2 = this.client.e;
        Class<? extends la> cls = er2.getEntityClass();
        try {
            la[] parts;
            la entity;
            if (er2.hasCustomSpawning()) {
                entity = er2.doCustomSpawning(packet);
            } else {
                entity = cls.getConstructor(xd.class).newInstance(wc2);
                entity.k = packet.entityId;
                entity.b(packet.scaledX, packet.scaledY, packet.scaledZ, packet.scaledYaw, packet.scaledPitch);
                if (entity instanceof lm) {
                    ((lm)entity).ay = packet.scaledHeadYaw;
                }
            }
            entity.cx = packet.rawX;
            entity.cy = packet.rawY;
            entity.cz = packet.rawZ;
            if (entity instanceof IThrowableEntity) {
                Object thrower = this.client.g.k == packet.throwerId ? this.client.g : wc2.a(packet.throwerId);
                ((IThrowableEntity)((Object)entity)).setThrower((la)thrower);
            }
            if ((parts = entity.ao()) != null) {
                int i2 = packet.entityId - entity.k;
                for (int j2 = 0; j2 < parts.length; ++j2) {
                    parts[j2].k += i2;
                }
            }
            if (packet.metadata != null) {
                entity.v().a(packet.metadata);
            }
            if (packet.throwerId > 0) {
                entity.h(packet.speedScaledX, packet.speedScaledY, packet.speedScaledZ);
            }
            if (entity instanceof IEntityAdditionalSpawnData) {
                ((IEntityAdditionalSpawnData)((Object)entity)).readSpawnData(packet.dataStream);
            }
            wc2.a(packet.entityId, entity);
            return entity;
        }
        catch (Exception e2) {
            FMLLog.log(Level.SEVERE, e2, "A severe problem occurred during the spawning of an entity", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
    }

    @Override
    public void adjustEntityLocationOnClient(EntitySpawnAdjustmentPacket packet) {
        la ent = this.client.e.a(packet.entityId);
        if (ent != null) {
            ent.cx = packet.serverX;
            ent.cy = packet.serverY;
            ent.cz = packet.serverZ;
        } else {
            FMLLog.fine("Attempted to adjust the position of entity %d which is not present on the client", packet.entityId);
        }
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.C();
    }

    @Override
    public void sendPacket(dw packet) {
        if (this.client.g != null) {
            this.client.g.a.c(packet);
        }
    }

    @Override
    public void displayMissingMods(ModMissingPacket modMissingPacket) {
        this.client.a(new GuiModsMissingForServer(modMissingPacket));
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void handleTinyPacket(dx handler, cq mapData) {
        ((awq)handler).fmlPacket131Callback(mapData);
    }

    @Override
    public void setClientCompatibilityLevel(byte compatibilityLevel) {
        awq.setConnectionCompatibilityLevel(compatibilityLevel);
    }

    @Override
    public byte getClientCompatibilityLevel() {
        return awq.getConnectionCompatibilityLevel();
    }
}

