/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.FMLTextureFX;
import cpw.mods.fml.client.ITextureFX;
import cpw.mods.fml.client.OverrideInfo;
import cpw.mods.fml.client.SpriteHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ModContainer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class TextureFXManager {
    private static final TextureFXManager INSTANCE = new TextureFXManager();
    private Map<Integer, TextureProperties> textureProperties = Maps.newHashMap();
    private Multimap<String, OverrideInfo> overrideInfo = ArrayListMultimap.create();
    private HashSet<OverrideInfo> animationSet = new HashSet();
    private List<bbh> addedTextureFX = new ArrayList<bbh>();
    private Minecraft client;
    private HashMap<Integer, Dimension> textureDims = new HashMap();
    private IdentityHashMap<bbh, Integer> effectTextures = new IdentityHashMap();
    private bcn earlyTexturePack;

    void setClient(Minecraft client) {
        this.client = client;
    }

    public boolean onUpdateTextureEffect(bbh effect) {
        ITextureFX ifx;
        ITextureFX iTextureFX = ifx = effect instanceof ITextureFX ? (ITextureFX)effect : null;
        if (ifx != null && ifx.getErrored()) {
            return false;
        }
        String name = effect.getClass().getSimpleName();
        this.client.I.a(name);
        try {
            if (!FMLClientHandler.instance().hasOptifine()) {
                effect.a();
            }
        }
        catch (Exception e2) {
            FMLLog.warning("Texture FX %s has failed to animate. Likely caused by a texture pack change that they did not respond correctly to", name);
            if (ifx != null) {
                ifx.setErrored(true);
            }
            this.client.I.b();
            return false;
        }
        this.client.I.b();
        if (ifx != null) {
            Dimension dim = this.getTextureDimensions(effect);
            int target = (dim.width >> 4) * (dim.height >> 4) << 2;
            if (effect.d.length != target) {
                FMLLog.warning("Detected a texture FX sizing discrepancy in %s (%d, %d)", name, effect.d.length, target);
                ifx.setErrored(true);
                return false;
            }
        }
        return true;
    }

    public void scaleTextureFXData(byte[] data, ByteBuffer buf, int target, int length) {
        int sWidth = (int)Math.sqrt(data.length / 4);
        int factor = target / sWidth;
        byte[] tmp = new byte[4];
        buf.clear();
        if (factor > 1) {
            for (int y = 0; y < sWidth; ++y) {
                int sRowOff = sWidth * y;
                int tRowOff = target * y * factor;
                for (int x = 0; x < sWidth; ++x) {
                    int sPos = (x + sRowOff) * 4;
                    tmp[0] = data[sPos + 0];
                    tmp[1] = data[sPos + 1];
                    tmp[2] = data[sPos + 2];
                    tmp[3] = data[sPos + 3];
                    int tPosTop = x * factor + tRowOff;
                    for (int y2 = 0; y2 < factor; ++y2) {
                        buf.position((tPosTop + y2 * target) * 4);
                        for (int x2 = 0; x2 < factor; ++x2) {
                            buf.put(tmp);
                        }
                    }
                }
            }
        }
        buf.position(0).limit(length);
    }

    public void onPreRegisterEffect(bbh effect) {
        Dimension dim = this.getTextureDimensions(effect);
        if (effect instanceof ITextureFX) {
            ((ITextureFX)effect).onTextureDimensionsUpdate(dim.width, dim.height);
        }
    }

    public int getEffectTexture(bbh effect) {
        Integer id2 = this.effectTextures.get(effect);
        if (id2 != null) {
            return id2;
        }
        int old = GL11.glGetInteger((int)32873);
        effect.a(this.client.o);
        id2 = GL11.glGetInteger((int)32873);
        GL11.glBindTexture((int)3553, (int)old);
        this.effectTextures.put(effect, id2);
        return id2;
    }

    public void onTexturePackChange(azb engine, bcn texturepack, List<bbh> effects) {
        this.pruneOldTextureFX(texturepack, effects);
        for (bbh tex : effects) {
            if (!(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTexturePackChanged(engine, texturepack, this.getTextureDimensions(tex));
        }
        this.loadTextures(texturepack);
    }

    public void setTextureDimensions(int id2, int width, int height, List<bbh> effects) {
        Dimension dim = new Dimension(width, height);
        this.textureDims.put(id2, dim);
        for (bbh tex : effects) {
            if (this.getEffectTexture(tex) != id2 || !(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTextureDimensionsUpdate(width, height);
        }
    }

    public Dimension getTextureDimensions(bbh effect) {
        return this.getTextureDimensions(this.getEffectTexture(effect));
    }

    public Dimension getTextureDimensions(int id2) {
        return this.textureDims.get(id2);
    }

    public void addAnimation(bbh anim) {
        OverrideInfo info = new OverrideInfo();
        info.index = anim.e;
        info.imageIndex = anim.i;
        info.textureFX = anim;
        if (this.animationSet.contains(info)) {
            this.animationSet.remove(info);
        }
        this.animationSet.add(info);
    }

    public void loadTextures(bcn texturePack) {
        this.registerTextureOverrides(this.client.o);
    }

    public void registerTextureOverrides(azb renderer) {
        for (OverrideInfo animationOverride : this.animationSet) {
            renderer.a(animationOverride.textureFX);
            this.addedTextureFX.add(animationOverride.textureFX);
            FMLCommonHandler.instance().getFMLLogger().finer(String.format("Registered texture override %d (%d) on %s (%d)", animationOverride.index, animationOverride.textureFX.e, animationOverride.textureFX.getClass().getSimpleName(), animationOverride.textureFX.i));
        }
        for (String fileToOverride : this.overrideInfo.keySet()) {
            for (OverrideInfo override : this.overrideInfo.get((Object)fileToOverride)) {
                try {
                    BufferedImage image = this.loadImageFromTexturePack(renderer, override.override);
                    ModTextureStatic mts = new ModTextureStatic(override.index, 1, override.texture, image);
                    renderer.a(mts);
                    this.addedTextureFX.add(mts);
                    FMLCommonHandler.instance().getFMLLogger().finer(String.format("Registered texture override %d (%d) on %s (%d)", override.index, mts.e, override.texture, mts.i));
                }
                catch (IOException e2) {
                    FMLCommonHandler.instance().getFMLLogger().throwing("FMLClientHandler", "registerTextureOverrides", e2);
                }
            }
        }
    }

    protected void registerAnimatedTexturesFor(ModContainer mod) {
    }

    public void onEarlyTexturePackLoad(bcn fallback) {
        if (this.client == null) {
            this.earlyTexturePack = fallback;
        } else {
            this.loadTextures(fallback);
        }
    }

    public void pruneOldTextureFX(bcn var1, List<bbh> effects) {
        ListIterator<bbh> li2 = this.addedTextureFX.listIterator();
        while (li2.hasNext()) {
            bbh tex = li2.next();
            if (tex instanceof FMLTextureFX) {
                if (!((FMLTextureFX)tex).unregister(this.client.o, effects)) continue;
                li2.remove();
                continue;
            }
            effects.remove(tex);
            li2.remove();
        }
    }

    public void addNewTextureOverride(String textureToOverride, String overridingTexturePath, int location) {
        OverrideInfo info = new OverrideInfo();
        info.index = location;
        info.override = overridingTexturePath;
        info.texture = textureToOverride;
        this.overrideInfo.put((Object)textureToOverride, (Object)info);
        FMLLog.fine("Overriding %s @ %d with %s. %d slots remaining", textureToOverride, location, overridingTexturePath, SpriteHelper.freeSlotCount(textureToOverride));
    }

    public BufferedImage loadImageFromTexturePack(azb renderEngine, String path) throws IOException {
        InputStream image = this.client.C.e().a(path);
        if (image == null) {
            throw new RuntimeException(String.format("The requested image path %s is not found", path));
        }
        BufferedImage result = ImageIO.read(image);
        if (result == null) {
            throw new RuntimeException(String.format("The requested image path %s appears to be corrupted", path));
        }
        return result;
    }

    public static TextureFXManager instance() {
        return INSTANCE;
    }

    private class TextureProperties {
        private int textureId;
        private Dimension dim;

        private TextureProperties() {
        }
    }
}

