/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WorldAccessContainer;
import java.util.Arrays;
import java.util.Map;

public class FMLDummyContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLDummyContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw, LexManos");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. The mod loading system is compatible with ModLoader, all your ModLoader mods should work.";
        meta.url = "https://github.com/cpw/FML/wiki";
        meta.updateUrl = "https://github.com/cpw/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        return true;
    }

    @Override
    public bg getDataForWriting(ags handler, agu info) {
        bg fmlData = new bg();
        bo list = new bo();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            bg mod = new bg();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            list.a((bt)mod);
        }
        fmlData.a("ModList", (bt)list);
        return fmlData;
    }

    @Override
    public void readData(ags handler, agu info, Map<String, bt> propertyMap, bg tag) {
        if (tag.b("ModList")) {
            bo modList = tag.m("ModList");
            for (int i2 = 0; i2 < modList.c(); ++i2) {
                bg mod = (bg)modList.b(i2);
                String modId = mod.i("ModId");
                String modVersion = mod.i("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.severe("This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.info("This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
    }
}

