/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.MinecraftDummyContainer;
import cpw.mods.fml.common.MissingModsException;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.WrongMinecraftVersionException;
import cpw.mods.fml.common.discovery.ModDiscoverer;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.functions.ModIdFunction;
import cpw.mods.fml.common.toposort.ModSorter;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class Loader {
    private static final Splitter DEPENDENCYPARTSPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    private static final Splitter DEPENDENCYSPLITTER = Splitter.on((String)";").omitEmptyStrings().trimResults();
    private static Loader instance;
    private static String major;
    private static String minor;
    private static String rev;
    private static String build;
    private static String mccversion;
    private static String mcsversion;
    private ModClassLoader modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
    private List<ModContainer> mods;
    private Map<String, ModContainer> namedMods;
    private File canonicalConfigDir;
    private File canonicalMinecraftDir;
    private Exception capturedError;
    private File canonicalModsDir;
    private LoadController modController;
    private MinecraftDummyContainer minecraft;
    private static File minecraftDir;
    private static List<String> injectedContainers;

    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcsversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    private Loader() {
        String actualMCVersion = new b(null).a();
        if (!mccversion.equals(actualMCVersion)) {
            FMLLog.severe("This version of FML is built for Minecraft %s, we have detected Minecraft %s in your minecraft jar file", mccversion, actualMCVersion);
            throw new LoaderException();
        }
        this.minecraft = new MinecraftDummyContainer(actualMCVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortModList() {
        FMLLog.fine("Verifying mod requirements are satisfied", new Object[0]);
        try {
            HashBiMap modVersions = HashBiMap.create();
            for (ModContainer mod : this.getActiveModList()) {
                modVersions.put((Object)mod.getModId(), (Object)mod.getProcessedVersion());
            }
            for (ModContainer mod : this.getActiveModList()) {
                if (!mod.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.severe("The mod %s does not wish to run in Minecraft version %s. You will have to remove it to play.", mod.getModId(), this.getMCVersionString());
                    throw new WrongMinecraftVersionException(mod);
                }
                ImmutableMap names = Maps.uniqueIndex(mod.getRequirements(), (Function)new Function<ArtifactVersion, String>(){

                    public String apply(ArtifactVersion v) {
                        return v.getLabel();
                    }
                });
                HashSet versionMissingMods = Sets.newHashSet();
                Sets.SetView missingMods = Sets.difference(names.keySet(), (Set)modVersions.keySet());
                if (!missingMods.isEmpty()) {
                    FMLLog.severe("The mod %s (%s) requires mods %s to be available", mod.getModId(), mod.getName(), missingMods);
                    for (String modid : missingMods) {
                        versionMissingMods.add(names.get(modid));
                    }
                    throw new MissingModsException(versionMissingMods);
                }
                ImmutableList allDeps = ImmutableList.builder().addAll(mod.getDependants()).addAll(mod.getDependencies()).build();
                for (ArtifactVersion v : allDeps) {
                    if (!modVersions.containsKey((Object)v.getLabel()) || v.containsVersion((ArtifactVersion)modVersions.get((Object)v.getLabel()))) continue;
                    versionMissingMods.add(v);
                }
                if (versionMissingMods.isEmpty()) continue;
                FMLLog.severe("The mod %s (%s) requires mod versions %s to be available", mod.getModId(), mod.getName(), versionMissingMods);
                throw new MissingModsException(versionMissingMods);
            }
            FMLLog.fine("All mod requirements are satisfied", new Object[0]);
            ModSorter sorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.fine("Sorting mods into an ordered list", new Object[0]);
                List<ModContainer> sortedMods = sorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(sortedMods);
                this.mods.removeAll(sortedMods);
                sortedMods.addAll(this.mods);
                this.mods = sortedMods;
                FMLLog.fine("Mod sorting completed successfully", new Object[0]);
            }
            catch (ModSortingException sortException) {
                FMLLog.severe("A dependency cycle was detected in the input mod set so an ordering cannot be determined", new Object[0]);
                FMLLog.severe("The visited mod list is %s", sortException.getExceptionData().getVisitedNodes());
                FMLLog.severe("The first mod in the cycle is %s", sortException.getExceptionData().getFirstBadNode());
                FMLLog.log(Level.SEVERE, sortException, "The full error", new Object[0]);
                throw new LoaderException(sortException);
            }
        }
        catch (Throwable throwable) {
            FMLLog.fine("Mod sorting data:", new Object[0]);
            for (ModContainer mod : this.getActiveModList()) {
                if (mod.isImmutable()) continue;
                FMLLog.fine("\t%s(%s:%s): %s (%s)", mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules());
            }
            if (this.mods.size() == 0) {
                FMLLog.fine("No mods found to sort", new Object[0]);
            }
            throw throwable;
        }
        FMLLog.fine("Mod sorting data:", new Object[0]);
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.isImmutable()) continue;
            FMLLog.fine("\t%s(%s:%s): %s (%s)", mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules());
        }
        if (this.mods.size() == 0) {
            FMLLog.fine("No mods found to sort", new Object[0]);
        }
    }

    private ModDiscoverer identifyMods() {
        FMLLog.fine("Building injected Mod Containers %s", injectedContainers);
        File coremod = new File(minecraftDir, "coremods");
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, this.modClassLoader).newInstance();
            }
            catch (Exception e2) {
                FMLLog.log(Level.SEVERE, e2, "A problem occured instantiating the injected mod container %s", cont);
                throw new LoaderException(e2);
            }
            this.mods.add(new InjectedModContainer(mc, coremod));
        }
        ModDiscoverer discoverer = new ModDiscoverer();
        FMLLog.fine("Attempting to load mods contained in the minecraft jar file and associated classes", new Object[0]);
        discoverer.findClasspathMods(this.modClassLoader);
        FMLLog.fine("Minecraft jar mods loaded successfully", new Object[0]);
        FMLLog.info("Searching %s for mods", this.canonicalModsDir.getAbsolutePath());
        discoverer.findModDirMods(this.canonicalModsDir);
        this.mods.addAll(discoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, (Function)new ModIdFunction());
        FMLLog.info("Forge Mod Loader has identified %d mod%s to load", this.mods.size(), this.mods.size() != 1 ? "s" : "");
        return discoverer;
    }

    private void identifyDuplicates(List<ModContainer> mods) {
        boolean foundDupe = false;
        TreeMultimap dupsearch = TreeMultimap.create((Comparator)new ModIdComparator(), (Comparator)Ordering.arbitrary());
        for (ModContainer mc : mods) {
            if (mc.getSource() == null) continue;
            dupsearch.put((Object)mc, (Object)mc.getSource());
        }
        ImmutableMultiset duplist = Multisets.copyHighestCountFirst((Multiset)dupsearch.keys());
        for (Multiset.Entry e2 : duplist.entrySet()) {
            if (e2.getCount() <= 1) continue;
            FMLLog.severe("Found a duplicate mod %s at %s", ((ModContainer)e2.getElement()).getModId(), dupsearch.get(e2.getElement()));
            foundDupe = true;
        }
        if (foundDupe) {
            throw new LoaderException();
        }
    }

    private void initializeLoader() {
        boolean dirMade;
        String canonicalConfigPath;
        String canonicalModsPath;
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            this.canonicalMinecraftDir = minecraftDir.getCanonicalFile();
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
            this.canonicalModsDir = modsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            FMLLog.log(Level.SEVERE, ioe, "Failed to resolve loader directories: mods : %s ; config %s", this.canonicalModsDir.getAbsolutePath(), configDir.getAbsolutePath());
            throw new LoaderException(ioe);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.info("No mod directory found, creating one: %s", canonicalModsPath);
            dirMade = this.canonicalModsDir.mkdir();
            if (!dirMade) {
                FMLLog.severe("Unable to create the mod directory %s", canonicalModsPath);
                throw new LoaderException();
            }
            FMLLog.info("Mod directory created successfully", new Object[0]);
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.fine("No config directory found, creating one: %s", canonicalConfigPath);
            dirMade = this.canonicalConfigDir.mkdir();
            if (!dirMade) {
                FMLLog.severe("Unable to create the config directory %s", canonicalConfigPath);
                throw new LoaderException();
            }
            FMLLog.info("Config directory created successfully", new Object[0]);
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.severe("Attempting to load mods from %s, which is not a directory", canonicalModsPath);
            throw new LoaderException();
        }
        if (!configDir.isDirectory()) {
            FMLLog.severe("Attempting to load configuration from %s, which is not a directory", canonicalConfigPath);
            throw new LoaderException();
        }
    }

    public List<ModContainer> getModList() {
        return Loader.instance().mods != null ? ImmutableList.copyOf(Loader.instance().mods) : ImmutableList.of();
    }

    public void loadMods() {
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this);
        this.modController.transition(LoaderState.LOADING);
        ModDiscoverer disc = this.identifyMods();
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        this.mods = ImmutableList.copyOf(this.mods);
        for (File nonMod : disc.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            FMLLog.severe("FML has found a non-mod file %s in your mods directory. It will now be injected into your classpath. This could severe stability issues, it should be removed if possible.", nonMod.getName());
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e2) {
                FMLLog.log(Level.SEVERE, e2, "Encountered a weird problem with non-mod file injection : %s", nonMod.getName());
            }
        }
        this.modController.transition(LoaderState.CONSTRUCTING);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, this.modClassLoader, disc.getASMTable());
        this.modController.transition(LoaderState.PREINITIALIZATION);
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, disc.getASMTable(), this.canonicalConfigDir);
        this.modController.transition(LoaderState.INITIALIZATION);
    }

    private void disableRequestedMods() {
        String forcedModList = System.getProperty("fml.modStates", "");
        FMLLog.fine("Received a system property request '%s'", forcedModList);
        Map sysPropertyStateList = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)forcedModList);
        FMLLog.fine("System property request managing the state of %d mods", sysPropertyStateList.size());
        HashMap modStates = Maps.newHashMap();
        File forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties forcedModListProperties = new Properties();
        if (forcedModFile.exists() && forcedModFile.isFile()) {
            FMLLog.fine("Found a mod state file %s", forcedModFile.getName());
            try {
                forcedModListProperties.load(new FileReader(forcedModFile));
                FMLLog.fine("Loaded states for %d mods from file", forcedModListProperties.size());
            }
            catch (Exception e2) {
                FMLLog.log(Level.INFO, e2, "An error occurred reading the fmlModState.properties file", new Object[0]);
            }
        }
        modStates.putAll(Maps.fromProperties((Properties)forcedModListProperties));
        modStates.putAll(sysPropertyStateList);
        FMLLog.fine("After merging, found state information for %d mods", modStates.size());
        Map isEnabled = Maps.transformValues((Map)modStates, (Function)new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return Boolean.parseBoolean(input);
            }
        });
        for (Map.Entry entry : isEnabled.entrySet()) {
            if (!this.namedMods.containsKey(entry.getKey())) continue;
            FMLLog.info("Setting mod %s to enabled state %b", entry.getKey(), entry.getValue());
            this.namedMods.get(entry.getKey()).setEnabledState((Boolean)entry.getValue());
        }
    }

    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname) && Loader.instance().modController.getModState(Loader.instance.namedMods.get(modname)) != LoaderState.ModState.DISABLED;
    }

    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    public String getCrashInformation() {
        StringBuilder ret = new StringBuilder();
        List<String> branding = FMLCommonHandler.instance().getBrandings();
        Joiner.on((char)' ').skipNulls().appendTo(ret, branding.subList(1, branding.size()));
        if (this.modController != null) {
            this.modController.printModStates(ret);
        }
        return ret.toString();
    }

    public String getFMLVersionString() {
        return String.format("%s.%s.%s.%s", major, minor, rev, build);
    }

    public ClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        if (dependencyString == null || dependencyString.length() == 0) {
            return;
        }
        boolean parseFailure = false;
        for (String dep : DEPENDENCYSPLITTER.split((CharSequence)dependencyString)) {
            ArrayList depparts = Lists.newArrayList((Iterable)DEPENDENCYPARTSPLITTER.split((CharSequence)dep));
            if (depparts.size() != 2) {
                parseFailure = true;
                continue;
            }
            String instruction = (String)depparts.get(0);
            String target = (String)depparts.get(1);
            boolean targetIsAll = target.startsWith("*");
            if (targetIsAll && target.length() > 1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "required-after".equals(instruction)) {
                if (!targetIsAll) {
                    requirements.add(VersionParser.parseVersionReference(target));
                } else {
                    parseFailure = true;
                    continue;
                }
            }
            if (targetIsAll && target.indexOf(64) > -1) {
                parseFailure = true;
                continue;
            }
            if ("required-before".equals(instruction) || "before".equals(instruction)) {
                dependants.add(VersionParser.parseVersionReference(target));
                continue;
            }
            if ("required-after".equals(instruction) || "after".equals(instruction)) {
                dependencies.add(VersionParser.parseVersionReference(target));
                continue;
            }
            parseFailure = true;
        }
        if (parseFailure) {
            FMLLog.log(Level.WARNING, "Unable to parse dependency string %s", dependencyString);
            throw new LoaderException();
        }
    }

    public Map<String, ModContainer> getIndexedModList() {
        return ImmutableMap.copyOf(this.namedMods);
    }

    public void initializeMods() {
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.modController.transition(LoaderState.POSTINITIALIZATION);
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.modController.transition(LoaderState.AVAILABLE);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        FMLLog.info("Forge Mod Loader has successfully loaded %d mod%s", this.mods.size(), this.mods.size() == 1 ? "" : "s");
    }

    public ICrashCallable getCallableCrashInformation() {
        return new ICrashCallable(){

            @Override
            public String call() throws Exception {
                return Loader.this.getCrashInformation();
            }

            @Override
            public String getLabel() {
                return "FML";
            }
        };
    }

    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    public void serverStarting(Object server) {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, server);
        this.modController.transition(LoaderState.SERVER_STARTING);
    }

    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED);
    }

    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING);
        this.modController.transition(LoaderState.AVAILABLE);
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    public ModContainer activeModContainer() {
        return this.modController.activeContainer();
    }

    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    private class ModIdComparator
    implements Comparator<ModContainer> {
        private ModIdComparator() {
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            return o1.getModId().compareTo(o2.getModId());
        }
    }
}

