/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;

public class FMLNetworkHandler {
    private static final int FML_HASH = Hashing.murmur3_32().hashString((CharSequence)"FML").asInt();
    private static final int PROTOCOL_VERSION = 1;
    private static final FMLNetworkHandler INSTANCE = new FMLNetworkHandler();
    static final int LOGIN_RECEIVED = 1;
    static final int CONNECTION_VALID = 2;
    static final int FML_OUT_OF_DATE = -1;
    static final int MISSING_MODS_OR_VERSIONS = -2;
    private Map<ij, Integer> loginStates = Maps.newHashMap();
    private Map<ModContainer, NetworkModHandler> networkModHandlers = Maps.newHashMap();
    private Map<Integer, NetworkModHandler> networkIdLookup = Maps.newHashMap();

    public static void handlePacket250Packet(cz packet, bu network, dx handler) {
        String target = packet.a;
        if (target.startsWith("MC|")) {
            handler.handleVanilla250Packet(packet);
        }
        if (target.equals("FML")) {
            FMLNetworkHandler.instance().handleFMLPacket(packet, network, handler);
        } else {
            NetworkRegistry.instance().handleCustomPacket(packet, network, handler);
        }
    }

    public static void onConnectionEstablishedToServer(dx clientHandler, bu manager, dn login) {
        NetworkRegistry.instance().clientLoggedIn(clientHandler, manager, login);
    }

    private void handleFMLPacket(cz packet, bu network, dx netHandler) {
        FMLPacket pkt = FMLPacket.readPacket(packet.c);
        String userName = "";
        if (netHandler instanceof ij) {
            userName = ((ij)netHandler).h;
        } else {
            qf pl2 = netHandler.getPlayer();
            if (pl2 != null) {
                userName = pl2.c_();
            }
        }
        pkt.execute(network, this, netHandler, userName);
    }

    public static void onConnectionReceivedFromClient(ij netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        FMLNetworkHandler.instance().handleClientConnection(netLoginHandler, server, address, userName);
    }

    private void handleClientConnection(ij netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        if (!this.loginStates.containsKey(netLoginHandler)) {
            if (this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                FMLLog.fine("Connection from %s rejected - no FML packet received from client", userName);
                netLoginHandler.completeConnection("You don't have FML installed, you cannot connect to this server");
                return;
            }
            FMLLog.fine("Connection from %s was closed by vanilla minecraft", userName);
            return;
        }
        switch (this.loginStates.get(netLoginHandler)) {
            case 1: {
                String modKick = NetworkRegistry.instance().connectionReceived(netLoginHandler, netLoginHandler.b);
                if (modKick != null) {
                    netLoginHandler.completeConnection(modKick);
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                if (!this.handleVanillaLoginKick(netLoginHandler, server, address, userName)) {
                    this.loginStates.remove(netLoginHandler);
                    return;
                }
                ij.a(netLoginHandler, false);
                netLoginHandler.b.a((dw)this.getModListRequestPacket());
                this.loginStates.put(netLoginHandler, 2);
                break;
            }
            case 2: {
                netLoginHandler.completeConnection(null);
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -2: {
                netLoginHandler.completeConnection("The server requires mods that are absent or out of date on your client");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            case -1: {
                netLoginHandler.completeConnection("Your client is not running a new enough version of FML to connect to this server");
                this.loginStates.remove(netLoginHandler);
                break;
            }
            default: {
                netLoginHandler.completeConnection("There was a problem during FML negotiation");
                this.loginStates.remove(netLoginHandler);
            }
        }
    }

    private boolean handleVanillaLoginKick(ij netLoginHandler, MinecraftServer server, SocketAddress address, String userName) {
        gd playerList = server.ad();
        String kickReason = playerList.a(address, userName);
        if (kickReason != null) {
            netLoginHandler.completeConnection(kickReason);
        }
        return kickReason == null;
    }

    public static void handleLoginPacketOnServer(ij handler, dn login) {
        if (login.a == FML_HASH) {
            if (login.e == 1) {
                FMLLog.finest("Received valid FML login packet from %s", handler.b.c());
                FMLNetworkHandler.instance().loginStates.put(handler, 1);
            } else if (login.e != 1) {
                FMLLog.finest("Received incorrect FML (%x) login packet from %s", login.e, handler.b.c());
                FMLNetworkHandler.instance().loginStates.put(handler, -1);
            }
        } else {
            FMLLog.fine("Received invalid login packet (%x, %x) from %s", login.a, login.e, handler.b.c());
        }
    }

    static void setHandlerState(ij handler, int state) {
        FMLNetworkHandler.instance().loginStates.put(handler, state);
    }

    public static FMLNetworkHandler instance() {
        return INSTANCE;
    }

    public static dn getFMLFakeLoginPacket() {
        FMLCommonHandler.instance().getSidedDelegate().setClientCompatibilityLevel((byte)0);
        dn fake = new dn();
        fake.a = FML_HASH;
        fake.e = 1;
        fake.d = xm.a;
        fake.b = xo.a[0];
        return fake;
    }

    public cz getModListRequestPacket() {
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.MOD_LIST_REQUEST, new Object[0]));
    }

    public void registerNetworkMod(NetworkModHandler handler) {
        this.networkModHandlers.put(handler.getContainer(), handler);
        this.networkIdLookup.put(handler.getNetworkId(), handler);
    }

    public boolean registerNetworkMod(ModContainer container, Class<?> networkModClass, ASMDataTable asmData) {
        NetworkModHandler handler = new NetworkModHandler(container, networkModClass, asmData);
        if (handler.isNetworkMod()) {
            this.registerNetworkMod(handler);
        }
        return handler.isNetworkMod();
    }

    public NetworkModHandler findNetworkModHandler(Object mc) {
        if (mc instanceof ModContainer) {
            return this.networkModHandlers.get(mc);
        }
        if (mc instanceof Integer) {
            return this.networkIdLookup.get(mc);
        }
        return this.networkModHandlers.get(FMLCommonHandler.instance().findContainerFor(mc));
    }

    public Set<ModContainer> getNetworkModList() {
        return this.networkModHandlers.keySet();
    }

    public static void handlePlayerLogin(ig player, il netHandler, bu manager) {
        NetworkRegistry.instance().playerLoggedIn(player, netHandler, manager);
        GameRegistry.onPlayerLogin(player);
    }

    public Map<Integer, NetworkModHandler> getNetworkIdMap() {
        return this.networkIdLookup;
    }

    public void bindNetworkId(String key, Integer value) {
        Map<String, ModContainer> mods = Loader.instance().getIndexedModList();
        NetworkModHandler handler = this.findNetworkModHandler(mods.get(key));
        if (handler != null) {
            handler.setNetworkId(value);
            this.networkIdLookup.put(value, handler);
        }
    }

    public static void onClientConnectionToRemoteServer(dx netClientHandler, String server, int port, bu networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, port, networkManager);
    }

    public static void onClientConnectionToIntegratedServer(dx netClientHandler, MinecraftServer server, bu networkManager) {
        NetworkRegistry.instance().connectionOpened(netClientHandler, server, networkManager);
    }

    public static void onConnectionClosed(bu manager, qf player) {
        NetworkRegistry.instance().connectionClosed(manager, player);
    }

    public static void openGui(qf player, Object mod, int modGuiId, xd world, int x, int y, int z) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mod);
            if (nmh != null) {
                mc = nmh.getContainer();
            } else {
                FMLLog.warning("A mod tried to open a gui on the server without being a NetworkMod", new Object[0]);
                return;
            }
        }
        if (player instanceof ig) {
            NetworkRegistry.instance().openRemoteGui(mc, (ig)player, modGuiId, world, x, y, z);
        } else {
            NetworkRegistry.instance().openLocalGui(mc, player, modGuiId, world, x, y, z);
        }
    }

    public static dw getEntitySpawningPacket(la entity) {
        EntityRegistry.EntityRegistration er2 = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er2 == null) {
            return null;
        }
        if (er2.usesVanillaSpawning()) {
            return null;
        }
        return PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWN, er2, entity, FMLNetworkHandler.instance().findNetworkModHandler(er2.getContainer())));
    }

    public static void makeEntitySpawnAdjustment(int entityId, ig player, int serverX, int serverY, int serverZ) {
        cz pkt = PacketDispatcher.getPacket("FML", FMLPacket.makePacket(FMLPacket.Type.ENTITYSPAWNADJUSTMENT, entityId, serverX, serverY, serverZ));
        player.a.b((dw)pkt);
    }

    public static InetAddress computeLocalHost() throws IOException {
        InetAddress add = null;
        ArrayList addresses = Lists.newArrayList();
        InetAddress localHost = InetAddress.getLocalHost();
        for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (ni.isLoopback() || !ni.isUp()) continue;
            addresses.addAll(Collections.list(ni.getInetAddresses()));
            if (!addresses.contains(localHost)) continue;
            add = localHost;
            break;
        }
        if (add == null && !addresses.isEmpty()) {
            for (InetAddress addr : addresses) {
                if (addr.getAddress().length != 4) continue;
                add = addr;
                break;
            }
        }
        if (add == null) {
            add = localHost;
        }
        return add;
    }

    public static cl handleChatMessage(dx handler, cl chat) {
        return NetworkRegistry.instance().handleChat(handler, chat);
    }

    public static void handlePacket131Packet(dx handler, cq mapData) {
        if (handler instanceof il || mapData.a != ts.bd.cf) {
            NetworkRegistry.instance().handleTinyPacket(handler, mapData);
        } else {
            FMLCommonHandler.instance().handleTinyPacket(handler, mapData);
        }
    }

    public static int getCompatibilityLevel() {
        return 1;
    }

    public static boolean vanillaLoginPacketCompatibility() {
        return FMLCommonHandler.instance().getSidedDelegate().getClientCompatibilityLevel() == 0;
    }
}

