/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.EntitySpawnPacket;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends la>, EntityRegistration> entityClassRegistrations = HashBiMap.create();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(1, 255);
        for (Object id2 : le.d.keySet()) {
            this.availableIndicies.clear((Integer)id2);
        }
    }

    public static void registerModEntity(Class<? extends la> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id2, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    private void doModEntityRegistration(Class<? extends la> entityClass, String entityName, int id2, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc, entityClass, entityName, id2, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            this.entityNames.put(entityName, mc);
            if (!le.c.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc.getModId(), entityName);
                le.c.put(entityClass, entityModName);
                le.b.put(entityModName, entityClass);
                FMLLog.finest("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARNING, e2, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er2);
    }

    public static void registerGlobalEntityID(Class<? extends la> entityClass, String entityName, int id2) {
        if (le.c.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        id2 = EntityRegistry.instance().validateAndClaimId(id2);
        le.a(entityClass, (String)entityName, (int)id2);
    }

    private int validateAndClaimId(int id2) {
        int realId = id2;
        if (id2 < -128) {
            FMLLog.warning("Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", id2, Loader.instance().activeModContainer().getModId(), realId);
            realId += 3000;
        }
        if (realId < 0) {
            realId += 127;
        }
        try {
            UnsignedBytes.checkedCast((long)realId);
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.SEVERE, "The entity ID %d for mod %s is not an unsigned byte and may not work", id2, Loader.instance().activeModContainer().getModId());
        }
        if (!this.availableIndicies.get(realId)) {
            FMLLog.severe("The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", Loader.instance().activeModContainer().getModId(), id2);
        }
        this.availableIndicies.clear(realId);
        return realId;
    }

    public static void registerGlobalEntityID(Class<? extends la> entityClass, String entityName, int id2, int backgroundEggColour, int foregroundEggColour) {
        if (le.c.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        EntityRegistry.instance().validateAndClaimId(id2);
        le.a(entityClass, (String)entityName, (int)id2, (int)backgroundEggColour, (int)foregroundEggColour);
    }

    public static void addSpawn(Class<? extends lm> entityClass, int weightedProb, int min, int max, ln typeOfCreature, xy ... biomes) {
        for (xy biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            for (xz entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                break;
            }
            spawns.add(new xz(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, ln spawnList, xy ... biomes) {
        Class entityClazz = (Class)le.b.get(entityName);
        if (lm.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static void removeSpawn(Class<? extends lm> entityClass, ln typeOfCreature, xy ... biomes) {
        for (xy biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                xz entry = (xz)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, ln spawnList, xy ... biomes) {
        Class entityClazz = (Class)le.b.get(entityName);
        if (lm.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, spawnList, biomes);
        }
    }

    public static int findGlobalUniqueEntityId() {
        int res = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (res < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return res;
    }

    public EntityRegistration lookupModSpawn(Class<? extends la> clazz, boolean keepLooking) {
        Class<? extends la> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(hy entityTracker, la entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    @Deprecated
    public static EntityRegistration registerModLoaderEntity(Object mod, Class<? extends la> entityClass, int entityTypeId, int updateRange, int updateInterval, boolean sendVelocityInfo) {
        String entityName = (String)le.c.get(entityClass);
        if (entityName == null) {
            throw new IllegalArgumentException(String.format("The ModLoader mod %s has tried to register an entity tracker for a non-existent entity type %s", Loader.instance().activeModContainer().getModId(), entityClass.getCanonicalName()));
        }
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, entityTypeId, mod, updateRange, updateInterval, sendVelocityInfo);
        return (EntityRegistration)EntityRegistry.instance().entityClassRegistrations.get(entityClass);
    }

    public class EntityRegistration {
        private Class<? extends la> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<EntitySpawnPacket, la> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, Class<? extends la> entityClass, String entityName, int id2, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id2;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends la> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public la doCustomSpawning(EntitySpawnPacket packet) throws Exception {
            return (la)this.customSpawnCallback.apply((Object)packet);
        }

        public void setCustomSpawning(Function<EntitySpawnPacket, la> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

