/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IDispenseHandler;
import cpw.mods.fml.common.IDispenserHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.BlockProxy;
import cpw.mods.fml.common.registry.BlockTracker;
import cpw.mods.fml.common.registry.ItemProxy;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;

public class GameRegistry {
    private static Multimap<ModContainer, BlockProxy> blockRegistry = ArrayListMultimap.create();
    private static Multimap<ModContainer, ItemProxy> itemRegistry = ArrayListMultimap.create();
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ICraftingHandler> craftingHandlers = Lists.newArrayList();
    private static List<IDispenserHandler> dispenserHandlers = Lists.newArrayList();
    private static List<IPickupNotifier> pickupHandlers = Lists.newArrayList();
    private static List<IPlayerTracker> playerTrackers = Lists.newArrayList();

    public static void registerWorldGenerator(IWorldGenerator generator) {
        worldGenerators.add(generator);
    }

    public static void generateWorld(int chunkX, int chunkZ, xd world, yw chunkGenerator, yw chunkProvider) {
        long worldSeed = world.D();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    public static void registerDispenserHandler(IDispenserHandler handler) {
        dispenserHandlers.add(handler);
    }

    @Deprecated
    public static void registerDispenserHandler(final IDispenseHandler handler) {
        GameRegistry.registerDispenserHandler(new IDispenserHandler(){

            @Override
            public int dispense(int x, int y, int z, int xVelocity, int zVelocity, xd world, tu item, Random random, double entX, double entY, double entZ) {
                return handler.dispense(x, y, z, xVelocity, zVelocity, world, item, random, entX, entY, entZ);
            }
        });
    }

    public static int tryDispense(xd world, int x, int y, int z, int xVelocity, int zVelocity, tu item, Random random, double entX, double entY, double entZ) {
        for (IDispenserHandler handler : dispenserHandlers) {
            int dispensed = handler.dispense(x, y, z, xVelocity, zVelocity, world, item, random, entX, entY, entZ);
            if (dispensed <= -1) continue;
            return dispensed;
        }
        return -1;
    }

    public static Object buildBlock(ModContainer container, Class<?> type, Mod.Block annotation) throws Exception {
        Object o2 = type.getConstructor(Integer.TYPE).newInstance(GameRegistry.findSpareBlockId());
        GameRegistry.registerBlock((ale)o2);
        return o2;
    }

    private static int findSpareBlockId() {
        return BlockTracker.nextBlockId();
    }

    public static void registerBlock(ale block) {
        GameRegistry.registerBlock(block, ut.class);
    }

    public static void registerBlock(ale block, Class<? extends ut> itemclass) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            assert (itemclass != null) : "registerBlock: itemclass cannot be null";
            int blockItemId = block.cm - 256;
            itemclass.getConstructor(Integer.TYPE).newInstance(blockItemId);
        }
        catch (Exception e2) {
            FMLLog.log(Level.SEVERE, e2, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e2);
        }
        blockRegistry.put((Object)Loader.instance().activeModContainer(), (Object)((BlockProxy)((Object)block)));
    }

    public static void addRecipe(tu output, Object ... params) {
        vp.a().a(output, params);
    }

    public static void addShapelessRecipe(tu output, Object ... params) {
        vp.a().b(output, params);
    }

    public static void addRecipe(vr recipe) {
        vp.a().b().add(recipe);
    }

    public static void addSmelting(int input, tu output, float xp2) {
        vl.a().a(input, output, xp2);
    }

    public static void registerTileEntity(Class<? extends aml> tileEntityClass, String id2) {
        aml.a(tileEntityClass, id2);
    }

    public static void addBiome(xy biome) {
        xo.b.addNewBiome(biome);
    }

    public static void removeBiome(xy biome) {
        xo.b.removeBiome(biome);
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(tu itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static void registerCraftingHandler(ICraftingHandler handler) {
        craftingHandlers.add(handler);
    }

    public static void onItemCrafted(qf player, tu item, kk craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onCrafting(player, item, craftMatrix);
        }
    }

    public static void onItemSmelted(qf player, tu item) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onSmelting(player, item);
        }
    }

    public static void registerPickupHandler(IPickupNotifier handler) {
        pickupHandlers.add(handler);
    }

    public static void onPickupNotification(qf player, pf item) {
        for (IPickupNotifier notify : pickupHandlers) {
            notify.notifyPickup(item, player);
        }
    }

    public static void registerPlayerTracker(IPlayerTracker tracker) {
        playerTrackers.add(tracker);
    }

    public static void onPlayerLogin(qf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogin(player);
        }
    }

    public static void onPlayerLogout(qf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerLogout(player);
        }
    }

    public static void onPlayerChangedDimension(qf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerChangedDimension(player);
        }
    }

    public static void onPlayerRespawn(qf player) {
        for (IPlayerTracker tracker : playerTrackers) {
            tracker.onPlayerRespawn(player);
        }
    }
}

