/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.FMLLogFormatter;
import cpw.mods.fml.relauncher.FMLRelauncher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FMLRelaunchLog {
    public static FMLRelaunchLog log = new FMLRelaunchLog();
    static File minecraftHome;
    private static boolean configured;
    private static Thread consoleLogThread;
    private static PrintStream errCache;
    private Logger myLog;

    private FMLRelaunchLog() {
    }

    private static void configureLogging() {
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
        FMLRelaunchLog.log.myLog = Logger.getLogger("ForgeModLoader");
        Logger stdOut = Logger.getLogger("STDOUT");
        stdOut.setParent(FMLRelaunchLog.log.myLog);
        Logger stdErr = Logger.getLogger("STDERR");
        stdErr.setParent(FMLRelaunchLog.log.myLog);
        FMLLogFormatter formatter = new FMLLogFormatter();
        FMLRelaunchLog.log.myLog.setUseParentHandlers(false);
        FMLRelaunchLog.log.myLog.addHandler(new ConsoleLogWrapper());
        consoleLogThread = new Thread(new ConsoleLogThread());
        consoleLogThread.start();
        ConsoleLogThread.wrappedHandler.setLevel(Level.parse(System.getProperty("fml.log.level", "INFO")));
        ConsoleLogThread.wrappedHandler.setFormatter(formatter);
        FMLRelaunchLog.log.myLog.setLevel(Level.ALL);
        try {
            File logPath = new File(minecraftHome, FMLRelauncher.logFileNamePattern);
            FileHandler fileHandler = new FileHandler(logPath.getPath(), 0, 3);
            fileHandler.setFormatter(formatter);
            fileHandler.setLevel(Level.ALL);
            FMLRelaunchLog.log.myLog.addHandler(fileHandler);
        }
        catch (Exception e2) {
            // empty catch block
        }
        errCache = System.err;
        System.setOut(new PrintStream(new LoggingOutStream(stdOut), true));
        System.setErr(new PrintStream(new LoggingOutStream(stdErr), true));
        configured = true;
    }

    public static void log(Level level, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data));
    }

    public static void log(Level level, Throwable ex2, String format, Object ... data) {
        if (!configured) {
            FMLRelaunchLog.configureLogging();
        }
        FMLRelaunchLog.log.myLog.log(level, String.format(format, data), ex2);
    }

    public static void severe(String format, Object ... data) {
        FMLRelaunchLog.log(Level.SEVERE, format, data);
    }

    public static void warning(String format, Object ... data) {
        FMLRelaunchLog.log(Level.WARNING, format, data);
    }

    public static void info(String format, Object ... data) {
        FMLRelaunchLog.log(Level.INFO, format, data);
    }

    public static void fine(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINE, format, data);
    }

    public static void finer(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINER, format, data);
    }

    public static void finest(String format, Object ... data) {
        FMLRelaunchLog.log(Level.FINEST, format, data);
    }

    public Logger getLogger() {
        return this.myLog;
    }

    private static class LoggingOutStream
    extends ByteArrayOutputStream {
        private Logger log;
        private StringBuilder currentMessage;

        public LoggingOutStream(Logger log) {
            this.log = log;
            this.currentMessage = new StringBuilder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Class<FMLRelaunchLog> clazz = FMLRelaunchLog.class;
            synchronized (FMLRelaunchLog.class) {
                super.flush();
                String record = this.toString();
                super.reset();
                this.currentMessage.append(record.replace(FMLLogFormatter.LINE_SEPARATOR, "\n"));
                if (this.currentMessage.lastIndexOf("\n") >= 0) {
                    if (this.currentMessage.length() > 1) {
                        this.currentMessage.setLength(this.currentMessage.length() - 1);
                        this.log.log(Level.INFO, this.currentMessage.toString());
                    }
                    this.currentMessage.setLength(0);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }

    private static class ConsoleLogThread
    implements Runnable {
        static ConsoleHandler wrappedHandler = new ConsoleHandler();
        static LinkedBlockingQueue<LogRecord> recordQueue = new LinkedBlockingQueue();

        private ConsoleLogThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    LogRecord lr2 = recordQueue.take();
                    wrappedHandler.publish(lr2);
                    continue;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace(errCache);
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
    }

    private static class ConsoleLogWrapper
    extends Handler {
        private ConsoleLogWrapper() {
        }

        @Override
        public void publish(LogRecord record) {
            boolean currInt = Thread.interrupted();
            try {
                ConsoleLogThread.recordQueue.put(record);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace(errCache);
            }
            if (currInt) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

