/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RelaunchClassLoader
extends URLClassLoader {
    private static String[] excludedPackages = new String[0];
    private static String[] transformerExclusions = new String[0];
    private List<URL> sources;
    private ClassLoader parent;
    private List<IClassTransformer> transformers;
    private Map<String, Class> cachedClasses;
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();

    public RelaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.parent = this.getClass().getClassLoader();
        this.cachedClasses = new HashMap<String, Class>(1000);
        this.transformers = new ArrayList<IClassTransformer>(2);
        Thread.currentThread().setContextClassLoader(this);
        this.addClassLoaderExclusion("java.");
        this.addClassLoaderExclusion("sun.");
        this.addClassLoaderExclusion("cpw.mods.fml.relauncher.");
        this.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.addTransformerExclusion("javax.");
        this.addTransformerExclusion("org.objectweb.asm.");
        this.addTransformerExclusion("com.google.common.");
        this.addTransformerExclusion("cpw.mods.fml.common.asm.SideOnly");
        this.addTransformerExclusion("cpw.mods.fml.common.Side");
    }

    public void registerTransformer(String transformerClassName) {
        try {
            this.transformers.add((IClassTransformer)this.loadClass(transformerClassName).newInstance());
        }
        catch (Exception e2) {
            FMLRelaunchLog.log(Level.SEVERE, e2, "A critical problem occured registering the ASM transformer class %s", transformerClassName);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (excludedPackages.length != 0) {
            this.classLoaderExceptions.addAll(Arrays.asList(excludedPackages));
            excludedPackages = new String[0];
        }
        if (transformerExclusions.length != 0) {
            this.transformerExceptions.addAll(Arrays.asList(transformerExclusions));
            transformerExclusions = new String[0];
        }
        for (String st2 : this.classLoaderExceptions) {
            if (!name.startsWith(st2)) continue;
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        for (String st2 : this.transformerExceptions) {
            if (!name.startsWith(st2)) continue;
            Class<?> cl2 = super.findClass(name);
            this.cachedClasses.put(name, cl2);
            return cl2;
        }
        try {
            String pkgname;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > -1 && this.getPackage(pkgname = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            byte[] basicClass = this.getClassBytes(name);
            byte[] transformedClass = this.runTransformers(name, basicClass);
            Class<?> cl3 = this.defineClass(name, transformedClass, 0, transformedClass.length);
            this.cachedClasses.put(name, cl3);
            return cl3;
        }
        catch (Throwable e2) {
            throw new ClassNotFoundException(name, e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        InputStream classStream = null;
        try {
            URL classResource = this.findResource(name.replace('.', '/').concat(".class"));
            if (classResource == null) {
                byte[] byArray = null;
                return byArray;
            }
            classStream = classResource.openStream();
            byte[] byArray = this.readFully(classStream);
            return byArray;
        }
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    private byte[] runTransformers(String name, byte[] basicClass) {
        for (IClassTransformer transformer : this.transformers) {
            basicClass = transformer.transform(name, basicClass);
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            int r2;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(stream.available());
            while ((r2 = stream.read()) != -1) {
                bos.write(r2);
            }
            return bos.toByteArray();
        }
        catch (Throwable t) {
            return new byte[0];
        }
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    private void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }
}

