/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    private ArrayList<kg> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        ChestGenHooks.addInfo(MINESHAFT_CORRIDOR, abp.a, 3, 7);
        ChestGenHooks.addInfo(PYRAMID_DESERT_CHEST, act.i, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_CHEST, acu.l, 2, 7);
        ChestGenHooks.addInfo(PYRAMID_JUNGLE_DISPENSER, acu.m, 2, 2);
        ChestGenHooks.addInfo(STRONGHOLD_CORRIDOR, ade.a, 2, 4);
        ChestGenHooks.addInfo(STRONGHOLD_LIBRARY, adi.b, 1, 5);
        ChestGenHooks.addInfo(STRONGHOLD_CROSSING, adn.c, 1, 5);
        ChestGenHooks.addInfo(VILLAGE_BLACKSMITH, ael.a, 3, 9);
        ChestGenHooks.addInfo(BONUS_CHEST, id.S, 10, 10);
    }

    private static void addInfo(String category, kg[] items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static tu[] generateStacks(Random rand, tu source, int min, int max) {
        tu[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new tu[]{};
        } else if (count > source.b().k()) {
            ret = new tu[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.l();
                ret[x].a = 1;
            }
        } else {
            ret = new tu[]{source.l()};
            ret[0].a = count;
        }
        return ret;
    }

    public static kg[] getItems(String category) {
        return ChestGenHooks.getInfo(category).getItems();
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, kg item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, tu item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, kg[] items, int min, int max) {
        this(category);
        for (kg item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(kg item) {
        this.contents.add(item);
    }

    public void removeItem(tu item) {
        Iterator<kg> itr = this.contents.iterator();
        while (itr.hasNext()) {
            kg cont = itr.next();
            if (!item.a(cont.itemStack) && (item.j() != -1 || item.c != cont.itemStack.c)) continue;
            itr.remove();
        }
    }

    public kg[] getItems() {
        return this.contents.toArray(new kg[this.contents.size()]);
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

