/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.Property;

public class Configuration {
    private static boolean[] configBlocks = new boolean[ale.p.length];
    private static boolean[] configItems = new boolean[ts.e.length];
    private static final int ITEM_SHIFT = 256;
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLOCK = "block";
    public static final String CATEGORY_ITEM = "item";
    public static final String ALLOWED_CHARS = "._-";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final CharMatcher allowedProperties = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"._-"));
    File file;
    public Map<String, Map<String, Property>> categories = new TreeMap<String, Map<String, Property>>();
    @Deprecated
    public TreeMap<String, Property> blockProperties = new TreeMap();
    @Deprecated
    public TreeMap<String, Property> itemProperties = new TreeMap();
    @Deprecated
    public TreeMap<String, Property> generalProperties = new TreeMap();
    private Map<String, String> customCategoryComments = Maps.newHashMap();
    private boolean caseSensitiveCustomCategories;
    public String defaultEncoding = "UTF-8";

    public Configuration(File file) {
        this.file = file;
        this.categories.put(CATEGORY_GENERAL, this.generalProperties);
        this.categories.put(CATEGORY_BLOCK, this.blockProperties);
        this.categories.put(CATEGORY_ITEM, this.itemProperties);
    }

    public Configuration(File file, boolean caseSensitiveCustomCategories) {
        this(file);
        this.caseSensitiveCustomCategories = caseSensitiveCustomCategories;
    }

    public Property getBlock(String key, int defaultID) {
        return this.getBlock(CATEGORY_BLOCK, key, defaultID);
    }

    public Property getBlock(String category, String key, int defaultID) {
        Property prop = this.get(category, key, -1);
        if (prop.getInt() != -1) {
            Configuration.configBlocks[prop.getInt()] = true;
            return prop;
        }
        if (ale.p[defaultID] == null && !configBlocks[defaultID]) {
            prop.value = Integer.toString(defaultID);
            Configuration.configBlocks[defaultID] = true;
            return prop;
        }
        for (int j2 = configBlocks.length - 1; j2 > 0; --j2) {
            if (ale.p[j2] != null || configBlocks[j2]) continue;
            prop.value = Integer.toString(j2);
            Configuration.configBlocks[j2] = true;
            return prop;
        }
        throw new RuntimeException("No more block ids available for " + key);
    }

    public Property getItem(String key, int defaultID) {
        return this.getItem(CATEGORY_ITEM, key, defaultID);
    }

    public Property getItem(String category, String key, int defaultID) {
        Property prop = this.get(category, key, -1);
        int defaultShift = defaultID + 256;
        if (prop.getInt() != -1) {
            Configuration.configItems[prop.getInt() + 256] = true;
            return prop;
        }
        if (ts.e[defaultShift] == null && !configItems[defaultShift] && defaultShift > ale.p.length) {
            prop.value = Integer.toString(defaultID);
            Configuration.configItems[defaultShift] = true;
            return prop;
        }
        for (int x = configItems.length - 1; x >= 256; --x) {
            if (ts.e[x] != null || configItems[x]) continue;
            prop.value = Integer.toString(x - 256);
            Configuration.configItems[x] = true;
            return prop;
        }
        throw new RuntimeException("No more item ids available for " + key);
    }

    public Property get(String category, String key, int defaultValue) {
        Property prop = this.get(category, key, Integer.toString(defaultValue), Property.Type.INTEGER);
        if (!prop.isIntValue()) {
            prop.value = Integer.toString(defaultValue);
        }
        return prop;
    }

    public Property get(String category, String key, boolean defaultValue) {
        Property prop = this.get(category, key, Boolean.toString(defaultValue), Property.Type.BOOLEAN);
        if (!prop.isBooleanValue()) {
            prop.value = Boolean.toString(defaultValue);
        }
        return prop;
    }

    public Property get(String category, String key, String defaultValue) {
        return this.get(category, key, defaultValue, Property.Type.STRING);
    }

    public Property get(String category, String key, String defaultValue, Property.Type type) {
        Map<String, Property> source;
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        if ((source = this.categories.get(category)) == null) {
            source = new TreeMap<String, Property>();
            this.categories.put(category, source);
        }
        if (source.containsKey(key)) {
            return source.get(key);
        }
        if (defaultValue != null) {
            Property prop = new Property(key, defaultValue, type);
            source.put(key, prop);
            return prop;
        }
        return null;
    }

    public boolean hasCategory(String category) {
        return this.categories.get(category) != null;
    }

    public boolean hasKey(String category, String key) {
        Map<String, Property> cat = this.categories.get(category);
        return cat != null && cat.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block31: {
            BufferedReader buffer = null;
            try {
                boolean quoted;
                if (this.file.getParentFile() != null) {
                    this.file.getParentFile().mkdirs();
                }
                if (!this.file.exists() && !this.file.createNewFile()) {
                    return;
                }
                if (!this.file.canRead()) break block31;
                UnicodeInputStreamReader input = new UnicodeInputStreamReader(new FileInputStream(this.file), this.defaultEncoding);
                this.defaultEncoding = input.getEncoding();
                buffer = new BufferedReader(input);
                Map<String, Property> currentMap = null;
                do {
                    String line;
                    if ((line = buffer.readLine()) == null) {
                        break block31;
                    }
                    int nameStart = -1;
                    int nameEnd = -1;
                    boolean skip = false;
                    quoted = false;
                    block22: for (int i2 = 0; i2 < line.length() && !skip; ++i2) {
                        if (Character.isLetterOrDigit(line.charAt(i2)) || ALLOWED_CHARS.indexOf(line.charAt(i2)) != -1 || quoted && line.charAt(i2) != '\"') {
                            if (nameStart == -1) {
                                nameStart = i2;
                            }
                            nameEnd = i2;
                            continue;
                        }
                        if (Character.isWhitespace(line.charAt(i2))) continue;
                        switch (line.charAt(i2)) {
                            case '#': {
                                skip = true;
                                continue block22;
                            }
                            case '\"': {
                                if (quoted) {
                                    quoted = false;
                                }
                                if (quoted || nameStart != -1) continue block22;
                                quoted = true;
                                continue block22;
                            }
                            case '{': {
                                String scopeName = line.substring(nameStart, nameEnd + 1);
                                currentMap = this.categories.get(scopeName);
                                if (currentMap != null) continue block22;
                                currentMap = new TreeMap<String, Property>();
                                this.categories.put(scopeName, currentMap);
                                continue block22;
                            }
                            case '}': {
                                currentMap = null;
                                continue block22;
                            }
                            case '=': {
                                String propertyName = line.substring(nameStart, nameEnd + 1);
                                if (currentMap == null) {
                                    throw new RuntimeException("property " + propertyName + " has no scope");
                                }
                                Property prop = new Property();
                                prop.setName(propertyName);
                                prop.value = line.substring(i2 + 1);
                                i2 = line.length();
                                currentMap.put(propertyName, prop);
                                continue block22;
                            }
                            default: {
                                throw new RuntimeException("unknown character " + line.charAt(i2));
                            }
                        }
                    }
                } while (!quoted);
                throw new RuntimeException("unmatched quote");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void save() {
        try {
            if (this.file.getParentFile() != null) {
                this.file.getParentFile().mkdirs();
            }
            if (!this.file.exists() && !this.file.createNewFile()) {
                return;
            }
            if (this.file.canWrite()) {
                FileOutputStream fos = new FileOutputStream(this.file);
                BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.defaultEncoding));
                buffer.write("# Configuration file\r\n");
                buffer.write("# Generated on " + DateFormat.getInstance().format(new Date()) + "\r\n");
                buffer.write("\r\n");
                for (Map.Entry<String, Map<String, Property>> category : this.categories.entrySet()) {
                    buffer.write("####################\r\n");
                    buffer.write("# " + category.getKey() + " \r\n");
                    if (this.customCategoryComments.containsKey(category.getKey())) {
                        buffer.write("#===================\r\n");
                        String comment = this.customCategoryComments.get(category.getKey());
                        Splitter splitter = Splitter.onPattern((String)"\r?\n");
                        for (String commentLine : splitter.split((CharSequence)comment)) {
                            buffer.write("# ");
                            buffer.write(commentLine + "\r\n");
                        }
                    }
                    buffer.write("####################\r\n\r\n");
                    String catKey = category.getKey();
                    if (!allowedProperties.matchesAllOf((CharSequence)catKey)) {
                        catKey = '\"' + catKey + '\"';
                    }
                    buffer.write(catKey + " {\r\n");
                    this.writeProperties(buffer, category.getValue().values());
                    buffer.write("}\r\n\r\n");
                }
                buffer.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addCustomCategoryComment(String category, String comment) {
        if (!this.caseSensitiveCustomCategories) {
            category = category.toLowerCase(Locale.ENGLISH);
        }
        this.customCategoryComments.put(category, comment);
    }

    private void writeProperties(BufferedWriter buffer, Collection<Property> props) throws IOException {
        for (Property property : props) {
            String propName;
            if (property.comment != null) {
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)property.comment)) {
                    buffer.write("   # " + commentLine + "\r\n");
                }
            }
            if (!allowedProperties.matchesAllOf((CharSequence)(propName = property.getName()))) {
                propName = '\"' + propName + '\"';
            }
            buffer.write("   " + propName + "=" + property.value);
            buffer.write("\r\n");
        }
    }

    @Deprecated
    public Property getOrCreateIntProperty(String key, String category, int defaultValue) {
        return this.get(category, key, defaultValue);
    }

    @Deprecated
    public Property getOrCreateProperty(String key, String category, String defaultValue) {
        return this.get(category, key, defaultValue);
    }

    @Deprecated
    public Property getOrCreateBooleanProperty(String key, String category, boolean defaultValue) {
        return this.get(category, key, defaultValue);
    }

    @Deprecated
    public Property getOrCreateBlockIdProperty(String key, int defaultID) {
        return this.getBlock(CATEGORY_BLOCK, key, defaultID);
    }

    static {
        Arrays.fill(configBlocks, false);
        Arrays.fill(configItems, false);
    }

    public static class UnicodeInputStreamReader
    extends Reader {
        private final InputStreamReader input;
        private final String defaultEnc;

        public UnicodeInputStreamReader(InputStream source, String encoding) throws IOException {
            this.defaultEnc = encoding;
            String enc = encoding;
            byte[] data = new byte[4];
            PushbackInputStream pbStream = new PushbackInputStream(source, data.length);
            int read = pbStream.read(data, 0, data.length);
            int size = 0;
            int bom16 = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
            int bom24 = bom16 << 8 | data[2] & 0xFF;
            int bom32 = bom24 << 8 | data[3] & 0xFF;
            if (bom24 == 0xEFBBBF) {
                enc = Configuration.DEFAULT_ENCODING;
                size = 3;
            } else if (bom16 == 65279) {
                enc = "UTF-16BE";
                size = 2;
            } else if (bom16 == 65534) {
                enc = "UTF-16LE";
                size = 2;
            } else if (bom32 == 65279) {
                enc = "UTF-32BE";
                size = 4;
            } else if (bom32 == -131072) {
                enc = "UTF-32LE";
                size = 4;
            }
            if (size < read) {
                pbStream.unread(data, size, read - size);
            }
            this.input = new InputStreamReader((InputStream)pbStream, enc);
        }

        public String getEncoding() {
            return this.input.getEncoding();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.input.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }
    }
}

