/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class DimensionManager {
    private static Hashtable<Integer, Class<? extends zq>> providers = new Hashtable();
    private static Hashtable<Integer, Boolean> spawnSettings = new Hashtable();
    private static Hashtable<Integer, id> worlds = new Hashtable();
    private static boolean hasInit = false;
    private static Hashtable<Integer, Integer> dimensions = new Hashtable();
    private static Map<xd, ListMultimap<ww, String>> persistentChunkStore = Maps.newHashMap();
    private static ArrayList<Integer> unloadQueue = new ArrayList();
    private static BitSet dimensionMap = new BitSet(1024);

    public static boolean registerProviderType(int id2, Class<? extends zq> provider, boolean keepLoaded) {
        if (providers.containsValue(id2)) {
            return false;
        }
        providers.put(id2, provider);
        spawnSettings.put(id2, keepLoaded);
        return true;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        DimensionManager.registerProviderType(0, zs.class, true);
        DimensionManager.registerProviderType(-1, zr.class, true);
        DimensionManager.registerProviderType(1, zt.class, false);
        DimensionManager.registerDimension(0, 0);
        DimensionManager.registerDimension(-1, -1);
        DimensionManager.registerDimension(1, 1);
    }

    public static void registerDimension(int id2, int providerType) {
        if (!providers.containsKey(providerType)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, provider type %d does not exist", id2, providerType));
        }
        if (dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id2));
        }
        dimensions.put(id2, providerType);
        if (id2 >= 0) {
            dimensionMap.set(id2);
        }
    }

    public static void unregisterDimension(int id2) {
        if (!dimensions.containsKey(id2)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id2));
        }
        dimensions.remove(id2);
    }

    public static int getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return dimensions.get(dim);
    }

    public static zq getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).v;
    }

    public static Integer[] getIDs() {
        return worlds.keySet().toArray(new Integer[worlds.size()]);
    }

    public static void setWorld(int id2, id world) {
        if (world != null) {
            worlds.put(id2, world);
            MinecraftServer.D().worldTickTimes.put(id2, new long[100]);
            FMLLog.info("Loading dimension %d (%s) (%s)", id2, world.J().k(), world.o());
        } else {
            worlds.remove(id2);
            MinecraftServer.D().worldTickTimes.remove(id2);
            FMLLog.info("Unloading dimension %d", id2);
        }
        ArrayList<id> tmp = new ArrayList<id>();
        if (worlds.get(0) != null) {
            tmp.add(worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add(worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add(worlds.get(1));
        }
        for (Map.Entry<Integer, id> entry : worlds.entrySet()) {
            int dim = entry.getKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add(entry.getValue());
        }
        MinecraftServer.D().c = tmp.toArray(new id[0]);
    }

    public static void initDimension(int dim) {
        id overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.o();
        agv savehandler = overworld.I();
        xl worldSettings = new xl(overworld.J());
        id world = dim == 0 ? overworld : new hx(mcServer, savehandler, overworld.J().k(), dim, worldSettings, overworld, mcServer.b);
        world.a((xj)new hz(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.I()) {
            world.J().a(mcServer.g());
        }
        mcServer.c(mcServer.h());
    }

    public static id getWorld(int id2) {
        return worlds.get(id2);
    }

    public static id[] getWorlds() {
        return worlds.values().toArray(new id[0]);
    }

    public static boolean shouldLoadSpawn(int dim) {
        int id2 = DimensionManager.getProviderType(dim);
        return spawnSettings.contains(id2) && spawnSettings.get(id2) != false;
    }

    public static Integer[] getStaticDimensionIDs() {
        return dimensions.keySet().toArray(new Integer[dimensions.keySet().size()]);
    }

    public static zq createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                zq provider = providers.get(DimensionManager.getProviderType(dim)).newInstance();
                provider.setDimension(dim);
                return provider;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, String.format("An error occured trying to create an instance of WorldProvider %d (%s)", dim, providers.get(DimensionManager.getProviderType(dim)).getSimpleName()), e);
            throw new RuntimeException(e);
        }
    }

    public static void unloadWorld(int id2) {
        unloadQueue.add(id2);
    }

    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        for (int id2 : unloadQueue) {
            try {
                worlds.get(id2).a(true, null);
            }
            catch (xi e) {
                e.printStackTrace();
            }
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(worlds.get(id2)));
            worlds.get(id2).m();
            DimensionManager.setWorld(id2, null);
        }
        unloadQueue.clear();
    }

    public static int getNextFreeDimId() {
        int next = 0;
        while (dimensions.containsKey(next = dimensionMap.nextClearBit(next))) {
            dimensionMap.set(next);
        }
        return next;
    }

    public static bg saveDimensionDataMap() {
        int[] data = new int[(dimensionMap.length() + 32 - 1) / 32];
        bg dimMap = new bg();
        for (int i2 = 0; i2 < data.length; ++i2) {
            int val = 0;
            for (int j2 = 0; j2 < 32; ++j2) {
                val |= dimensionMap.get(i2 * 32 + j2) ? 1 << j2 : 0;
            }
            data[i2] = val;
        }
        dimMap.a("DimensionArray", data);
        return dimMap;
    }

    public static void loadDimensionDataMap(bg compoundTag) {
        if (compoundTag == null) {
            dimensionMap.clear();
            for (Integer id2 : dimensions.keySet()) {
                if (id2 < 0) continue;
                dimensionMap.set(id2);
            }
        } else {
            int[] intArray = compoundTag.k("DimensionArray");
            for (int i2 = 0; i2 < intArray.length; ++i2) {
                for (int j2 = 0; j2 < 32; ++j2) {
                    dimensionMap.set(i2 * 32 + j2, (intArray[i2] & 1 << j2) != 0);
                }
            }
        }
    }

    static {
        DimensionManager.init();
    }
}

