/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<ts, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(xd world, int x, int y, int z) {
        GrassEntry grass = (GrassEntry)ke.a((Random)world.u, grassList);
        if (grass == null || grass.block == null || !grass.block.d(world, x, y, z)) {
            return;
        }
        world.d(x, y, z, grass.block.cm, grass.metadata);
    }

    public static tu getGrassSeed(xd world) {
        SeedEntry entry = (SeedEntry)ke.a((Random)world.u, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.l();
    }

    public static boolean canHarvestBlock(ale block, qf player, int metadata) {
        if (block.cB.l()) {
            return true;
        }
        tu stack = player.bJ.g();
        if (stack == null) {
            return player.b(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.b(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.b(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(ale block, qf player, xd world, int x, int y, int z) {
        int metadata = world.g(x, y, z);
        float hardness = block.m(world, x, y, z);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(tu stack, ale block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        if (toolClass == null) {
            return false;
        }
        return toolEffectiveness.contains(Arrays.asList(block, metadata, (String)toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(ts.t, "pickaxe", 0);
        MinecraftForge.setToolClass(ts.x, "pickaxe", 1);
        MinecraftForge.setToolClass(ts.g, "pickaxe", 2);
        MinecraftForge.setToolClass(ts.I, "pickaxe", 0);
        MinecraftForge.setToolClass(ts.B, "pickaxe", 3);
        MinecraftForge.setToolClass(ts.u, "axe", 0);
        MinecraftForge.setToolClass(ts.y, "axe", 1);
        MinecraftForge.setToolClass(ts.h, "axe", 2);
        MinecraftForge.setToolClass(ts.J, "axe", 0);
        MinecraftForge.setToolClass(ts.C, "axe", 3);
        MinecraftForge.setToolClass(ts.s, "shovel", 0);
        MinecraftForge.setToolClass(ts.w, "shovel", 1);
        MinecraftForge.setToolClass(ts.f, "shovel", 2);
        MinecraftForge.setToolClass(ts.H, "shovel", 0);
        MinecraftForge.setToolClass(ts.A, "shovel", 3);
        for (ale block : ub.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (ale block : um.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (ale block : tq.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(ale.as, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(ale.bU, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.az, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.aA, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.J, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.ak, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.K, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(ale.al, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(ale.Q, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(ale.R, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(ale.aQ, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(ale.aR, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(ale.aQ, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(ale.as, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(ale.aR, "pickaxe");
    }

    public static String getTexture(String _default, Object obj) {
        if (obj instanceof ts) {
            return ((ts)obj).getTextureFile();
        }
        if (obj instanceof ale) {
            return ((ale)obj).getTextureFile();
        }
        return _default;
    }

    public static int getTotalArmorValue(qf player) {
        int ret = 0;
        for (int x = 0; x < player.bJ.b.length; ++x) {
            tu stack = player.bJ.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.b())).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof sb)) continue;
            ret += ((sb)stack.b()).b;
        }
        return ret;
    }

    public static boolean onPickBlock(amt target, qf player, xd world) {
        int x;
        tu result = null;
        boolean isCreative = player.ce.d;
        if (target.a == amu.a) {
            x = target.b;
            int y = target.c;
            int z = target.d;
            ale var8 = ale.p[world.a(x, y, z)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x, y, z);
        } else {
            if (target.a != amu.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x = 0; x < 9; ++x) {
            tu stack = player.bJ.a(x);
            if (stack == null || !stack.a(result)) continue;
            player.bJ.c = x;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bJ.i();
        if (slot < 0 || slot >= 9) {
            slot = player.bJ.c;
        }
        player.bJ.a(slot, result);
        player.bJ.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(lm entity, lm target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(lm entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(lm entity, kr src, int amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static int onLivingHurt(lm entity, kr src, int amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0 : event.ammount;
    }

    public static boolean onLivingDeath(lm entity, kr src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(lm entity, kr source, ArrayList<pf> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(lm entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(ale block, xd world, int x, int y, int z) {
        return block != null && block.isLadder(world, x, y, z);
    }

    public static void onLivingJump(lm entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static pf onPlayerTossEvent(qf player, tu item) {
        player.captureDrops = true;
        pf ret = player.a(item, false);
        player.capturedDrops.clear();
        player.captureDrops = false;
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    static {
        grassList.add(new GrassEntry(ale.ag, 0, 20));
        grassList.add(new GrassEntry(ale.ah, 0, 10));
        seedList.add(new SeedEntry(new tu(ts.S), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends kf {
        public final tu seed;

        public SeedEntry(tu seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends kf {
        public final ale block;
        public final int metadata;

        public GrassEntry(ale block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

