/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinecartRegistry {
    private static Map<MinecartKey, tu> itemForMinecart = new HashMap<MinecartKey, tu>();
    private static Map<tu, MinecartKey> minecartForItem = new HashMap<tu, MinecartKey>();

    public static void registerMinecart(Class<? extends pg> cart, tu item) {
        MinecartRegistry.registerMinecart(cart, 0, item);
    }

    public static void registerMinecart(Class<? extends pg> minecart, int type, tu item) {
        MinecartKey key = new MinecartKey(minecart, type);
        itemForMinecart.put(key, item);
        minecartForItem.put(item, key);
    }

    public static void removeMinecart(Class<? extends pg> minecart, int type) {
        MinecartKey key = new MinecartKey(minecart, type);
        tu item = itemForMinecart.remove(key);
        if (item != null) {
            minecartForItem.remove(item);
        }
    }

    public static tu getItemForCart(Class<? extends pg> minecart) {
        return MinecartRegistry.getItemForCart(minecart, 0);
    }

    public static tu getItemForCart(Class<? extends pg> minecart, int type) {
        tu item = itemForMinecart.get(new MinecartKey(minecart, type));
        if (item == null) {
            return null;
        }
        return item.l();
    }

    public static tu getItemForCart(pg cart) {
        return MinecartRegistry.getItemForCart(cart.getClass(), cart.getMinecartType());
    }

    public static Class<? extends pg> getCartClassForItem(tu item) {
        MinecartKey key = null;
        for (Map.Entry<tu, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.minecart;
        }
        return null;
    }

    public static int getCartTypeForItem(tu item) {
        MinecartKey key = null;
        for (Map.Entry<tu, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.type;
        }
        return -1;
    }

    public static Set<tu> getAllCartItems() {
        HashSet<tu> ret = new HashSet<tu>();
        for (tu item : minecartForItem.keySet()) {
            ret.add(item.l());
        }
        return ret;
    }

    static {
        MinecartRegistry.registerMinecart(pg.class, 0, new tu(ts.az));
        MinecartRegistry.registerMinecart(pg.class, 1, new tu(ts.aN));
        MinecartRegistry.registerMinecart(pg.class, 2, new tu(ts.aO));
    }

    public static class MinecartKey {
        public final Class<? extends pg> minecart;
        public final int type;

        public MinecartKey(Class<? extends pg> cls, int typtID) {
            this.minecart = cls;
            this.type = typtID;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MinecartKey other = (MinecartKey)obj;
            if (!(this.minecart == other.minecart || this.minecart != null && this.minecart.equals(other.minecart))) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.minecart != null ? this.minecart.hashCode() : 0);
            hash = 59 * hash + this.type;
            return hash;
        }
    }
}

